// macros containing expressions that start with a bracket problem


def main
// triacon_data ("triacon facet spec"); end
logfile (datapath+"geo info.txt"); geometrics ()
// geo_roof (); end
// generate_menus ("geometrics")
end

def geometrics
// 1 unit = 100mm
num "##.#####" // number format and precision
 new pov_file="geo.inc"
 new flora off
meta group "structure and material"
 new wall_thickness=1.5
 new dome_radius=24
 new dome_base off
 new inner_layer off
 new inner_wall on
 new glazing off
 new strut_size= 0.5 / dome_radius  // cylinder radius
 new strut_size_reduction= 0.8
 // new strut_texture="$ texture { pigment { color rgb <0.2, 0.9, 0.7 > } }"
 new strut_texture="$ texture { pigment { color rgbt <0.2, 0.9, 0.7, 0 > } } finish {ambient 0.7}"
 // new strut_texture="$ texture { pigment { color rgb <0.7, 0.4, 0.3 > } }"
 new membrane  on
 new inner_wall_texture="$ texture { pigment { color rgbt <0.8, 0.8, 0.7, 0.0 > } }"
 new glazing_texture="$ texture { pigment { color rgbt <0.2, 0.2, 0.2, 0.5 > } } finish {reflection 0.6}"
 // new membrane_texture="$ texture { pigment { color rgbt <0.4, 0.7, 0.3, 0.4 > } }"
 // new membrane_texture="do gravel; " // override
 // new membrane_texture="mortar(1,0.1); " // override
 new membrane_texture1="herbage (0.35,0.4,3)" // amb blue scale
 new membrane_texture2="floral (0.7, 0.8, 0.8, 0.0, 0.7, 0.1 , 0.3 ); " // amb r g b scale cover
 new membrane_texture3="floral (0.7, 0.2, 0.0, 0.8, 0.7, 0.0 , 0.1 ); " // amb r g b scale cover
 new membrane_texture=membrane_texture1+membrane_texture2+membrane_texture3
 new truss_membrane on
 new truss_membrane_texture= "$ texture { pigment { color rgbt <0.6, 0.6, 0.2, 0.3 > } }
meta group end
meta group "geometry"
 new shape="ii"
 new elliptic=   1
 new divisions=  0
 new division_3f=0
 new primary   on
 new kite      off
 new trunc     off
 new truncated_form=0
 new iso_kite  off
 new iso_diamond  off
 new mesh      off
 new diamond   off
 new node_size= 0 // 1.7
 new truss_size=1/2
 new truss_level=0
 new pent on
 new small_openings=0
 new hemi off
meta group end
meta group "taking measurements"
 new facet_data off
 new one_unit_only off
meta group end
meta group "files"
 new pov_file="geo.pov"
meta group end
meta end
new pentt off
new pentk off
new tally=0
new sector=0
new isoc=0
new formula="ii0"
// formula='sp0o2he.5'
if exist(progpath+"geo custom.pro"); load progpath+"geo custom.pro"; do settings; unload
if trim(codeword); formula=codeword
if formula
 new rt=lower(right(formula,4))
 if rt=".bmp"; formula=left(formula,len(formula)-4)
 say "formula [formula]"
 shape=left(formula,2); say "shape code [shape]"
 if shape="t"; isoc=1
 if shape="p6"; isoc=1
 divisions=val(mid(formula,3,1)); say "division stages [divisions]"
 new s=mid(formula,4)
 new a
 a=at("op",s); if a; s=patch(s,"  ",a); pentk on
 //
 if at("f",s); division_3f=1; say "of which first division is 3 frequency"
 if at("a",s); truncated_form on; primary off; say "truncated form"
 if at("c",s); trunc on;primary off; say "truncate apex"
 if at("k",s); kite on;primary off; say "split into kites"
 if at("g",s); glazing on; say "glazing available"
 if at("d",s); diamond on;primary off; say "construct diamonds"
 // if at("m",s); mesh on;primary off; say "construct mesh" // imperfect
 if at("h",s); hemi on; say "make hemisphere or nearest section"
 if at("p",s); pent off; say "leave pents open"
 if at("i",s); iso_kite on; iso_diamond on; say "optimise angles for diamonds and kites"
 //
 a=at("t",s)
 if a
  membrane off
  truss_level=val(mid(s,a+1,1)); say "trusses level [truss_level]"
  truss_size=val("0."+mid(s,a+2)); truss span size [truss_size]"
 endif
 a=at("o",s); if a; small_openings=val("0."+mid(s,a+1)); say "small openings size [small_openings]"
 a=at("n",s); if a; node_size=val(mid(s,a+1)); say "node size [node_size]"
 // a=at("e",s); if a; elliptic=val(mid(s,a+1)); say "elliptic factor [elliptic]"
endif
// files
output raypath+pov_file
$ // Generated by 'Explore Geodesics 1.'
$ // formula [formula]
deletefile (datapath+'geo.dxf')
deletefile (datapath+'geoplot.txt')
channel(1); file(datapath+'geo.dxf')
channel(2); file(datapath+'geoplot.txt'); channel(1)
new dxfpt=1, qpt=1, cr=\13+\10
// dxf header
new t='0'+cr+'SECTION'+cr+'2'+cr+'HEADER'+cr+'0'+cr+'ENDSEC'+cr _
 +'0'+cr+'SECTION'+cr+'2'+cr+'TABLES'+cr+'0'+cr+'TABLE'+cr+'2'+cr+'LAYER'+cr _
 +'70'+cr+'153'+cr+'0'+cr+'LAYER'+cr+'2'+cr+'Cube'+cr+'70'+cr+'0'+cr+'62'+cr+'31'+cr _
 +'6'+cr+'CONTINUOUS'+cr+'0'+cr+'ENDTAB'+cr+'0'+cr+'ENDSEC'+cr _
 +'0'+cr+'SECTION'+cr+'2'+cr+'ENTITIES'+cr
seek(dxfpt); put(t); dxfpt+len(t)
//
set done_formula=codeword
loop
which shape
// polyhedrals
// ? "fold"; fold_about_axis (); exit
// ? "sp"; solid(); exit
? "p4";  say "tetrahedron"; tetrahedron_xyz (); exit
// ? "p6";  say "hexahedron (double tetrahedron)"; hexahedron_xyz (); exit
? "pc";  say "cube"; cube_xyz (); exit
? "pp";  say "dodecahedron (12 pentagon faces) "; dodecahedron_xyz (); exit
// geodesics
? "ii";  say "icosahedron (20 faces)"; geo_icosahedron_xyz (); exit
? "oo";  say "octahedron (8 faces)"; geo_octahedron_xyz (); exit
? "ti";  say "icosahedron with 1 triaconic division (60 faces)"; geo_triacon_icosahedron_xyz (); exit
? "to";  say "octahedron with 1 triaconic division (24 faces)"; geo_triacon_octahedron_xyz (); exit
set done_formula='blank'; output datapath+'geo.pov'; out ' ';output ''
say "Unknown shape [shape] "
exit
endl
//
output ''
t='0'+cr+'ENDSEC'+cr+'0'+cr+'EOF'+cr
seek(dxfpt); put(t); dxfpt+len(t)
file('')
channel(2); file(''); channel(1)
// end of dxf and quick plot
new c
new t
c=tally
if kite; c*3
if diamond; c*1.5
if mesh; c*.6
if divisions=0; t=1; if kite or diamond; if formula="t"; t=2
if division_3f
 if divisions=1; if shape="i"; t=2; if kite or diamond; t=3
 if divisions=1; if shape="t"; t=6; if kite or diamond; t*3
else
 if divisions=1; if shape="i"; t=2; if kite; t=3
 if divisions=1; if shape="t"; t=4; if kite or diamond; t*3
endif
if divisions>1; t=t*power(4,divisions-1)
say "faces plotted [c]"
say "face types [t]"
if no pent
 new o=12
 say "main pent openings [o]"
endif
if small_openings
 new o
 o=12
 say "small pent openings [o]"
 if diamond
  if c>30
   o=c-30/3; say "small hex openings [o]"
  endif
 endif
 if kite
  if c>60
   o=c-60/6; say "small hex openings [o]"
  endif
 endif
endif
logfile(datapath+'geo dialog.txt')
end

def geo_roof
//$ #declare geodesic =
$//roof
//$ union {
new xx,yy,zz
new nx,ny,nz
new r,t,tg
r=0.01
t=0.04
ra=0.7
//
nz=0
tg=t
zz=-ra; nz=zz
loop
 xx=-ra
 tg=-tg
 yy=pyth(1,xx,zz,-1)
 loop
  $ union {
  nx=xx+t; if nx>ra; exit
  ny=pyth(1,nx,nz,-1)
  $// cylinder { < [xx],[yy],[zz]>,<[nx],[ny],[nz]> , [r] }
  xx=nx;yy=ny; zz=nz
  nx=xx+t; if nx>ra; exit
  nz=nz+tg
  ny=pyth(1,nx,nz,-1)
  strut (xx,yy,zz,nx,ny,nz)
  xx=nx;yy=ny; zz=nz
  nx=xx+t; if nx>ra; exit
  ny=pyth(1,nx,nz,-1)
  strut (xx,yy,zz,nx,ny,nz)
  xx=nx;yy=ny; zz=nz
  nx=xx+t; if nx>ra; exit
  nz=nz-tg
  ny=pyth(1,nx,nz,-1)
  strut (xx,yy,zz,nx,ny,nz)
  xx=nx;yy=ny; zz=nz
  [strut_texture]
  $ }
 endl
 nz+t
 if tg>0; nz+t
 if nz>ra; exit
 zz=nz
endl
object_attributes ()
end

def facet_data (na,x1,y1,z1,x2,y2,z2,x3,y3,z3)
// ww.log
new aa=pyth (x2-x1,y2-y1,z2-z1,1)
new cc=pyth (x3-x2,y3-y2,z3-z2,1)
new bb=pyth (x1-x3,y1-y3,z1-z3,1)
new A,B,C
// orientation for icos triangles
A=aa; B=bb; C=cc
if "[aa]"="[cc]"; A=cc; B=aa; C=bb
if "[bb]"="[cc]"; A=bb; B=cc; C=aa
if "[aa]"="[bb]"; A=aa; B=bb; C=cc
new d=(A*A)+(C*C)-(B*B) / C * 0.5, e=C-d
new h=pyth(A,d,-1), hh=h/2
 d*dome_radius
 e*dome_radius
 h*dome_radius
 hh*dome_radius
 A*dome_radius
 B*dome_radius
 C*dome_radius
say na
say "lside [A]  rside [B]        base [C]   height [h]"
say "lbase [d]  rbase [e]  halfheight [hh]  height [h]"
new la,ra, aa
la=atan(d,h)
ra=atan(e,h)
aa=la+ra
say "apex angles left  [la] right [ra] both [aa]"
say ""
end

def object_attributes ()
new a
// $ scale <1,[elliptic],1>
// [strut_texture]
// $ } // end geodesic
//$ //
//$ #declare geodesic_view =
//if dome_base or inner_layer
// $ union {
// $ object { geodesic translate <0,0.25,0> }
// if inner_layer
//  a=2 / dome_radius; a=1-a
//  $ object { geodesic scale [a] translate <0,0.25,0>
//  $ texture { pigment { color rgbt <0.8, 0.7, 0.7, 0.5 > } }
//  $ }
// endif
// if dome_base
//  $ difference {
//  $  cylinder { <0,0,0>,<0,0.25,0>,1 }
//  $  cylinder { <0,-0.1,0>,<0,0.25,0>,1 scale <.9,1.1,.9> }
//  $ texture { pigment { color White } }
//  $ finish { ambient 0.3 }
//  a=1 / dome_radius
//  $ normal { bumps 0.9 scale [a] }
//  $ }
// endif
//else
// $ object { geodesic translate <0,0,0>
//endif
//$ rotate <0,clock*180,0>
//$ scale [dome_radius]
//$ finish { ambient 0.3 }
//$ normal { bumps 0 }
//$ }
//
//$ #declare geo_form =
//$ object { geodesic_view
//$ rotate <-clock*90,0,0>
//$ translate <-10,0,40>
//$ }
//if flora; trees ()
end

def truncated_point (na,sp,rc,xc,yc,zc,bs=0,nu=0)
if (sp=1) .and. (nu=0); end
new i,ct,p,q,w
new xi,yi,zi
new xp,yp,zp
new xq,yq,zq
new xr,yr,zr
new xt,yt,zt
new xgc,ygc,zgc
new ex
w=word(na,1); if no w; end
xq=x[w]; yq=y[w]; zq=z[w]; if bs; xr=xq; yr=yq; zr=zq
xt=xq-xc*sp+xc
yt=yq-yc*sp+yc
zt=zq-zc*sp+zc

if nu; xq+xc/2; yq+yc/2; zq+zc/2
ex=0
$ union {
loop
 w=word(na,0)
 if no w; w=word(na,1); ex=1
 xp=x[w]; yp=y[w]; zp=z[w]
 xi=xp-xc*sp+xc; yi=yp-yc*sp+yc; zi=zp-zc*sp+zc
 if bs
  strut (xp,yp,zp,xr,yr,zr,rc) // base struts
  xr=xp; yr=yp; zr=zp
 endif
 if nu; xp+xc/2; yp+yc/2; zp+zc/2
 if (nu=0) .or. (sp<0.5)
  strut (xp,yp,zp,xi,yi,zi,rc) // truncated strut
 endif
 if sp>0
  strut (xt,yt,zt,xi,yi,zi,rc) // connect strut ends
  if membrane
   $ // membrane
   $ union {
   tri ('q p t }')
   tri ('t i p }')
   [membrane_texture]
   $ }
   if inner_wall
    p=dome_radius - wall_thickness / dome_radius
    $ union {
    inner_wall ( xq,yq,zq,xp,yp,zp,xt,yt,zt )  // poly
    inner_wall_o ( xt,yt,zt,xi,yi,zi,xp,yp,zp ) // poly
    [inner_wall_texture]
    $ }
   endif
   if glazing
    q=pyth(xt,yt,zt,1); xgc=xc*q; ygc=yc*q; zgc=zc*q
    p=pyth(xt-xgc,yt-ygc,zt-zgc,1)
    a=asin(p/2)*2; p=cos(a); xgc*p; ygc*p; zgc*p
    tri ('gc i t ')
    [glazing_texture]
    $ }
   endif
  endif
 else
  if membrane
   tri ('c q p ')
   [membrane_texture]
   $ }
  endif
 endif
 if ex; exit
 xq=xp; yq=yp; zq=zp
 xt=xi; yt=yi; zt=zi
endl
[strut_texture]
$ }
end

def central_spherepoint (na,sp,rc,xt,yt,zt)
new i,ct,p,w
new xi,yi,zi
i=0
set xt=0; yt=0; zt=0
w=word(na,1)
loop
 if no w; exit
 i+1
 xi=x[w]; set xt+xi //=pyth(xt,xi,1)
 yi=y[w]; set yt+yi //=pyth(yt,yi,1)
 zi=z[w]; set zt+zi //=pyth(zt,zi,1)
 w=word(na,0)
endl
ct=i
set xt/ct; yt/ct; zt/ct
p=1-pyth(xt,yt,zt,1) *sp // spherepoint adjustment
p=1/(1-p)
set xt*p; yt*p; zt*p
end

def poly_draw (na,rc)
if truncated_form
 new xs,ys,zs
 central_spherepoint (na,1,rc*0.8,&xs,&ys,&zs)
 truncated_point     (na,1/3,rc*0.8,&xs,&ys,&zs,1,0)
 end
endif
new xi,yi,zi,i=0,ct,p,w,ex=0
new xp,yp,zp
w=word(na,1)
set xt=0; yt=0; zt=0
$ union {
loop
 xp=x[w]; yp=y[w]; zp=z[w]
 set xt+xp; yt+yp; zt+zp
 w=word(na,0)
 if no w; w=word(na,1); ex=1
 xi=x[w]; yi=y[w]; zi=z[w]
 strut (xp,yp,zp,xi,yi,zi,rc)
 i+1
 if ex; exit
endl
[strut_texture]
$ }
ct=i
set xt/ct; yt/ct; zt/ct
if membrane
 i=0; w=word(na,1); ex=0
 $ union {
 loop
  xp=x[w]; yp=y[w]; zp=z[w]
  w=word(na,0); if no w; w=word(na,1); ex=1
  xi=x[w]; yi=y[w]; zi=z[w]
  tri ('t p i }')
  if ex; exit
 endl
 [membrane_texture]
 $ }
endif
end

def solid ()
 // \cevp\ww\mooncoy5.pro
new r=strut_size
new s=small_openings
new or=.99999
new ir=1-( wall_thickness / dome_radius )
$
$ #declare facing_wall =
$ intersection {
$ difference {
$ box { < -1,0,0>,<1,1,0.05 >
$ } // box
$ box { < -.6,0,-0.1>,<-.4,0.7,0.051 > }
$ box { < -.3,0,-0.1>,<-.1,0.7,0.051 > }
$ box { < 0,0,-0.1>,<.2,0.7,0.051 > }
$ box { < .3,0,-0.1>,<.5,0.7,0.051 > }
$ } // difference
struti (0,0,-0.1,0,0,0.1,1)
[strut_texture]
$ }
// [membrane_texture]
//$ normal { bumps 0 }
//$ finish { ambient 0.5 }
$ } // intersection
$
//$ #declare geodesic =
$ // spherics
//$ union {
$ difference {
$  union {
$   sphere { 0,[or]
    [inner_wall_texture]
$   } // sphere
$   sphere { 0,1
    [membrane_texture]
$   } // sphere
$  } // union
$  sphere { 0,[ir] }
if hemi; $ box { < 1.1,0, 1.1>,<-1.1, -1.1,-1.1> }
$ box { < -1.1,-1.1, -1.1>,<1.1,1.1,0 > } // cut out
$ // cylinder { <0,0,0>,<0,2,0>,[s] rotate <  0,  0,  0> }
$  cylinder { <0,0,0>,<0,2,0>,[s] rotate <-45, 180,  0> }
$  cylinder { <0,0,0>,<0,2,0>,[s] rotate <-45,225,  0> }
$  cylinder { <0,0,0>,<0,2,0>,[s] rotate <-45,135,  0> }
$ // cylinder { <0,0,0>,<0,2,0>,[s] rotate <-90,-45,  0> }
$ } // difference
$ union {
$ // base
$ difference {
$ cylinder { <0,0,0>,<0,-0.1,0>,1
  [inner_wall_texture]
$ } // cylinder
$ box { < -1.1,-1.1, -1.1>,<1.1,1.1,0 > } // cut out
$ } // difference
$ object  { facing_wall }
 // $ torus { 1, [r] rotate <  0,  0,  0 > }
 // $ torus { 1, [r] rotate < 90,  0,  0 > }
 // $ torus { 1, [r] rotate < 90, 90,  0 > }
 [strut_texture]
 $ } // union
object_attributes ()
end

def tetrahedron_xyz
new xs,ys,zs
new w,lo,la,t,r,c,u
new x1,x2,x3,x4
new y1,y2,y3,y4
new z1,z2,z3,z4
say "tetra"
new r=strut_size
new c=divisions
new n=isoc
u=sqr(2/3) // height of tet  (related to side)
u=asin(u)*2 // great arc
u=90-u
la=90 ; lo=000; y1=sin(la); w=cos(la); x1=sin(lo)*w; z1=cos(lo)*w
la=u  ; lo=000; y2=sin(la); w=cos(la); x2=sin(lo)*w; z2=cos(lo)*w
la=u  ; lo=120; y3=sin(la); w=cos(la); x3=sin(lo)*w; z3=cos(lo)*w
la=u  ; lo=240; y4=sin(la); w=cos(la); x4=sin(lo)*w; z4=cos(lo)*w
//$ #declare geodesic =
$ // tetrahedron
//$ union {

//central_spherepoint ("2  3  4  ",0.5,r,&xs,&ys,&zs)
//truncate            ("2  3  4  ",1/3,r,&xs,&ys,&zs)

geo_trixyz ('1 2 3')
geo_trixyz ('1 2 4')
geo_trixyz ('2 3 4')
geo_trixyz ('3 1 4')

object_attributes ()
end

def hexahedron_xyz ()
new xs,ys,zs
new w,lo,la,t,r,c,u
new xc1,xc2,xc3,xc4,xc5
new yc1,yc2,yc3,yc4,yc5
new zc1,zc2,zc3,zc4,zc5
r=strut_size
new c=divisions, n=isoc
la=90 ; lo=000; yc1=sin(la); w=cos(la); xc1=sin(lo)*w; zc1=cos(lo)*w
la=0  ; lo=000; yc2=sin(la); w=cos(la); xc2=sin(lo)*w; zc2=cos(lo)*w
la=0  ; lo=120; yc3=sin(la); w=cos(la); xc3=sin(lo)*w; zc3=cos(lo)*w
la=0  ; lo=240; yc4=sin(la); w=cos(la); xc4=sin(lo)*w; zc4=cos(lo)*w
la=-90; lo=000; yc5=sin(la); w=cos(la); xc5=sin(lo)*w; zc5=cos(lo)*w

//$ #declare geodesic =
$ // hexahedron
//$ union {

geo_trixyz ('c1 c2 c3')
geo_trixyz ('c1 c3 c4')
geo_trixyz ('c1 c4 c2')
geo_trixyz ('c5 c2 c3')
geo_trixyz ('c5 c3 c4')
geo_trixyz ('c5 c4 c2')

object_attributes ()
end

def cube_xyz
new xs,ys,zs
new w,lo,la,t,r,c,n,u,tt,uu
new xc1,xc2,xc3,xc4,xc5,xc6,xc7,xc8
new yc1,yc2,yc3,yc4,yc5,yc6,yc7,yc8
new zc1,zc2,zc3,zc4,zc5,zc6,zc7,zc8
//$ #declare geodesic =
$ // cube
//$ union {
r=strut_size
c=divisions
u=asin(1/sqr(3))
say u
la=u  ; lo=045; yc1=sin(la); w=cos(la); xc1=sin(lo)*w; zc1=cos(lo)*w
la=u  ; lo=135; yc2=sin(la); w=cos(la); xc2=sin(lo)*w; zc2=cos(lo)*w
la=u  ; lo=225; yc3=sin(la); w=cos(la); xc3=sin(lo)*w; zc3=cos(lo)*w
la=u  ; lo=315; yc4=sin(la); w=cos(la); xc4=sin(lo)*w; zc4=cos(lo)*w
u=-u
la=u  ; lo=045; yc5=sin(la); w=cos(la); xc5=sin(lo)*w; zc5=cos(lo)*w
la=u  ; lo=135; yc6=sin(la); w=cos(la); xc6=sin(lo)*w; zc6=cos(lo)*w
la=u  ; lo=225; yc7=sin(la); w=cos(la); xc7=sin(lo)*w; zc7=cos(lo)*w
la=u  ; lo=315; yc8=sin(la); w=cos(la); xc8=sin(lo)*w; zc8=cos(lo)*w

geo_quad ("c1 c2 c3 c4",r,n,c)
geo_quad ("c5 c6 c7 c8",r,n,c)
geo_quad ("c1 c4 c8 c5",r,n,c)
geo_quad ("c2 c1 c5 c6",r,n,c)
geo_quad ("c2 c6 c7 c3",r,n,c)
geo_quad ("c3 c7 c8 c4",r,n,c)

object_attributes ()
end

def geo_quad (list,r,n,c)
// geo.pov
if c<1
 poly_draw (list,r); end
endif
r*strut_size_reduction
@2=1
new s="[c]"
new w1=word(list,0), w2=word(list,0), w3=word(list,0), w4=word(list,0)
new x[s]1=x[w1],y[s]1=y[w1],z[s]1=z[w1]
new x[s]2=x[w2],y[s]2=y[w2],z[s]2=z[w2]
new x[s]3=x[w3],y[s]3=y[w3],z[s]3=z[w3]
new x[s]4=x[w4],y[s]4=y[w4],z[s]4=z[w4]

new xcc=x[w1]+x[w2]+x[w3]+x[w4] /4
new ycc=y[w1]+y[w2]+y[w3]+y[w4] /4
new zcc=z[w1]+z[w2]+z[w3]+z[w4] /4

new p
// shere points adjustment
p=1/pyth(xcc,ycc,zcc,1); xcc*p; ycc*p; zcc*p

if division_3f .and. (c=divisions)
 new xt1=x[s]2-x[s]1 /3+x[s]1, yt1=y[s]2-y[s]1 /3+y[s]1, zt1=z[s]2-z[s]1 /3+z[s]1
 new xt2=x[s]1-x[s]2 /3+x[s]2, yt2=y[s]1-y[s]2 /3+y[s]2, zt2=z[s]1-z[s]2 /3+z[s]2
 new xt3=x[s]3-x[s]2 /3+x[s]2, yt3=y[s]3-y[s]2 /3+y[s]2, zt3=z[s]3-z[s]2 /3+z[s]2
 new xt4=x[s]2-x[s]3 /3+x[s]3, yt4=y[s]2-y[s]3 /3+y[s]3, zt4=z[s]2-z[s]3 /3+z[s]3
 new xt5=x[s]4-x[s]3 /3+x[s]3, yt5=y[s]4-y[s]3 /3+y[s]3, zt5=z[s]4-z[s]3 /3+z[s]3
 new xt6=x[s]3-x[s]4 /3+x[s]4, yt6=y[s]3-y[s]4 /3+y[s]4, zt6=z[s]3-z[s]4 /3+z[s]4
 new xt7=x[s]1-x[s]4 /3+x[s]4, yt7=y[s]1-y[s]4 /3+y[s]4, zt7=z[s]1-z[s]4 /3+z[s]4
 new xt8=x[s]4-x[s]1 /3+x[s]1, yt8=y[s]4-y[s]1 /3+y[s]1, zt8=z[s]4-z[s]1 /3+z[s]1
 //
 new xc1=x[s]1-xcc/3+xcc, yc1=y[s]1-ycc/3+ycc, zc1=z[s]1-zcc/3+zcc
 new xc2=x[s]2-xcc/3+xcc, yc2=y[s]2-ycc/3+ycc, zc2=z[s]2-zcc/3+zcc
 new xc3=x[s]3-xcc/3+xcc, yc3=y[s]3-ycc/3+ycc, zc3=z[s]3-zcc/3+zcc
 new xc4=x[s]4-xcc/3+xcc, yc4=y[s]4-ycc/3+ycc, zc4=z[s]4-zcc/3+zcc
 //
 p=1/pyth(xc1,yc1,zc1,1); xc1*p; yc1*p; zc1*p
 p=1/pyth(xc2,yc2,zc2,1); xc2*p; yc2*p; zc2*p
 p=1/pyth(xc3,yc3,zc3,1); xc3*p; yc3*p; zc3*p
 p=1/pyth(xc4,yc4,zc4,1); xc4*p; yc4*p; zc4*p
 //
 p=1/pyth(xt1,yt1,zt1,1); xt1*p; yt1*p; zt1*p
 p=1/pyth(xt2,yt2,zt2,1); xt2*p; yt2*p; zt2*p
 p=1/pyth(xt3,yt3,zt3,1); xt3*p; yt3*p; zt3*p
 p=1/pyth(xt4,yt4,zt4,1); xt4*p; yt4*p; zt4*p
 //
 p=1/pyth(xt5,yt5,zt5,1); xt5*p; yt5*p; zt5*p
 p=1/pyth(xt6,yt6,zt6,1); xt6*p; yt6*p; zt6*p
 p=1/pyth(xt7,yt7,zt7,1); xt7*p; yt7*p; zt7*p
 p=1/pyth(xt8,yt8,zt8,1); xt8*p; yt8*p; zt8*p
 // recurse
 c-1
 geo_quad ("[s]1 t1 c1 t8",r,n,c); geo_quad ("t1 t2 c2 c1 ",r,n,c)
 geo_quad ("[s]2 t3 c2 t2",r,n,c); geo_quad ("t3 t4 c3 c2 ",r,n,c)
 geo_quad ("[s]3 t5 c3 t4",r,n,c); geo_quad ("t5 t6 c4 c3 ",r,n,c)
 geo_quad ("[s]4 t7 c4 t6",r,n,c); geo_quad ("t7 t8 c1 c4 ",r,n,c)
 geo_quad ("c1 c2 c3 c4",r,n,c)
else
 new xt1=x[s]2+x[s]1 /2, yt1=y[s]2+y[s]1 /2, zt1=z[s]2+z[s]1 /2
 new xt2=x[s]3+x[s]2 /2, yt2=y[s]3+y[s]2 /2, zt2=z[s]3+z[s]2 /2
 new xt3=x[s]4+x[s]3 /2, yt3=y[s]4+y[s]3 /2, zt3=z[s]4+z[s]3 /2
 new xt4=x[s]1+x[s]4 /2, yt4=y[s]1+y[s]4 /2, zt4=z[s]1+z[s]4 /2
 p=1/pyth(xt1,yt1,zt1,1); xt1*p; yt1*p; zt1*p
 p=1/pyth(xt2,yt2,zt2,1); xt2*p; yt2*p; zt2*p
 p=1/pyth(xt3,yt3,zt3,1); xt3*p; yt3*p; zt3*p
 p=1/pyth(xt4,yt4,zt4,1); xt4*p; yt4*p; zt4*p
 c-1
 geo_quad ("[s]1 t1 cc t4",r,n,c)
 geo_quad ("[s]2 t2 cc t1",r,n,c)
 geo_quad ("[s]3 t3 cc t2",r,n,c)
 geo_quad ("[s]4 t4 cc t3",r,n,c)

endif

end

def dodecahedron_xyz
new xs,ys,zs
new w,lo,la,t,r,c,n,u,tt,uu
new xc1,xc2,xc3,xc4,xc5,xc6,yc1,yc2,yc3,yc4,yc5,yc6,xc1,zc2,zc3,zc4,zc5,zc6
new xc11,xc12,xc13,xc14,xc15,xc16,yc11,yc12,yc13,yc14,yc15,yc16,xc11,zc12,zc13,zc14,zc15,zc16
new xc21,xc22,xc23,xc24,xc25,xc26,yc21,yc22,yc23,yc24,yc25,yc26,xc21,zc22,zc23,zc24,zc25,zc26
new xc31,xc32,xc33,xc34,xc35,xc36,yc31,yc32,yc33,yc34,yc35,yc36,xc31,zc32,zc33,zc34,zc35,zc36
//$ #declare geodesic =
$ // Icosahedron
// ww.log
new rc=strut_size
//$ union {
r=strut_size
// latitude of icos triangle
t=atn(2) // great arc for side of icos face = 63.43... degrees
tt=atan( 2*cos(36),1 ) // napier rules: cos A =  tan b / tan c
t=tt
// latitude of centre of icos triangle
uu=atan( tan(36)*sin( atn(2)/2 ), 1 ) // napier tan A=tan a / sin b
// centre of sphere x=0,y=0,z=0
rc=1.2*r
// top
// triacon
u=tt-uu
la=90-u; lo=036; yc2=sin(la); w=cos(la); xc2=sin(lo)*w; zc2=cos(lo)*w
la=90-u; lo=108; yc3=sin(la); w=cos(la); xc3=sin(lo)*w; zc3=cos(lo)*w
la=90-u; lo=180; yc4=sin(la); w=cos(la); xc4=sin(lo)*w; zc4=cos(lo)*w
la=90-u; lo=252; yc5=sin(la); w=cos(la); xc5=sin(lo)*w; zc5=cos(lo)*w
la=90-u; lo=324; yc6=sin(la); w=cos(la); xc6=sin(lo)*w; zc6=cos(lo)*w
u=tt+uu
la=90-u; lo=036; yc12=sin(la); w=cos(la); xc12=sin(lo)*w; zc12=cos(lo)*w
la=90-u; lo=108; yc13=sin(la); w=cos(la); xc13=sin(lo)*w; zc13=cos(lo)*w
la=90-u; lo=180; yc14=sin(la); w=cos(la); xc14=sin(lo)*w; zc14=cos(lo)*w
la=90-u; lo=252; yc15=sin(la); w=cos(la); xc15=sin(lo)*w; zc15=cos(lo)*w
la=90-u; lo=324; yc16=sin(la); w=cos(la); xc16=sin(lo)*w; zc16=cos(lo)*w
//u=tt+tt-uu
u=180-tt-uu
la=90-u; lo=000; yc22=sin(la); w=cos(la); xc22=sin(lo)*w; zc22=cos(lo)*w
la=90-u; lo=072; yc23=sin(la); w=cos(la); xc23=sin(lo)*w; zc23=cos(lo)*w
la=90-u; lo=144; yc24=sin(la); w=cos(la); xc24=sin(lo)*w; zc24=cos(lo)*w
la=90-u; lo=216; yc25=sin(la); w=cos(la); xc25=sin(lo)*w; zc25=cos(lo)*w
la=90-u; lo=288; yc26=sin(la); w=cos(la); xc26=sin(lo)*w; zc26=cos(lo)*w
//u=tt+tt+uu
u=180-tt+uu
la=90-u; lo=000; yc32=sin(la); w=cos(la); xc32=sin(lo)*w; zc32=cos(lo)*w
la=90-u; lo=072; yc33=sin(la); w=cos(la); xc33=sin(lo)*w; zc33=cos(lo)*w
la=90-u; lo=144; yc34=sin(la); w=cos(la); xc34=sin(lo)*w; zc34=cos(lo)*w
la=90-u; lo=216; yc35=sin(la); w=cos(la); xc35=sin(lo)*w; zc35=cos(lo)*w
la=90-u; lo=288; yc36=sin(la); w=cos(la); xc36=sin(lo)*w; zc36=cos(lo)*w

$ // pents

poly_draw ("c2  c3  c13 c23 c12",rc*0.8)
poly_draw ("c3  c4  c14 c24 c13",rc*0.8)
poly_draw ("c4  c5  c15 c25 c14",rc*0.8)
poly_draw ("c5  c6  c16 c26 c15",rc*0.8)
poly_draw ("c6  c2  c12 c22 c16",rc*0.8)

poly_draw ("c12 c23 c33 c32 c22",rc*0.8)
poly_draw ("c13 c24 c34 c33 c23",rc*0.8)
poly_draw ("c14 c25 c35 c34 c24",rc*0.8)
poly_draw ("c15 c26 c36 c35 c25",rc*0.8)
poly_draw ("c16 c22 c32 c36 c26",rc*0.8)

poly_draw ("c2  c3  c4  c5  c6 ",rc*0.8)
poly_draw ("c32 c33 c34 c35 c36",rc*0.8)

$ // end pent
object_attributes ()
end

def geo_triacon_icosahedron_xyz
new w,lo,la,t,r,c,n,u,tt,uu
new x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12
new y1,y2,y3,y4,y5,y6,y7,y8,y9,y10,y11,y12
new z1,z2,z3,z4,z5,z6,z7,z8,z9,z10,z11,z12
new xc1,xc2,xc3,xc4,xc5,xc6
new yc1,yc2,yc3,yc4,yc5,yc6
new xc1,zc2,zc3,zc4,zc5,zc6
new xc11,xc12,xc13,xc14,xc15,xc16
new yc11,yc12,yc13,yc14,yc15,yc16
new xc11,zc12,zc13,zc14,zc15,zc16
new xc21,xc22,xc23,xc24,xc25,xc26
new yc21,yc22,yc23,yc24,yc25,yc26
new xc21,zc22,zc23,zc24,zc25,zc26
new xc31,xc32,xc33,xc34,xc35,xc36
new yc31,yc32,yc33,yc34,yc35,yc36
new xc31,zc32,zc33,zc34,zc35,zc36

//$ #declare geodesic =
$ //
//$ union {
r=strut_size
new n=isoc
new c=divisions // triacon recursion level

// latitude of icos triangle
t=atn(2) // great arc for side of icos face = 63.43... degrees
tt=atan( 2*cos(36),1 ) // napier rules: cos A =  tan b / tan c
// latitude of centre of icos triangle
uu=atan( tan(36)*sin( atn(2)/2 ), 1 ) // napier tan A=tan a / sin b
// centre of sphere x=0,y=0,z=0
// top
new p
new v=atn(2)
la=90  ; lo=000; y1=sin(la); w=cos(la); x1=sin(lo)*w; z1=cos(lo)*w
la=90-v; lo=000; y2=sin(la); w=cos(la); x2=sin(lo)*w; z2=cos(lo)*w
la=90-v; lo=072; y3=sin(la); w=cos(la); x3=sin(lo)*w; z3=cos(lo)*w
la=90-v; lo=144; y4=sin(la); w=cos(la); x4=sin(lo)*w; z4=cos(lo)*w
la=90-v; lo=216; y5=sin(la); w=cos(la); x5=sin(lo)*w; z5=cos(lo)*w
la=90-v; lo=288; y6=sin(la); w=cos(la); x6=sin(lo)*w; z6=cos(lo)*w
//
// triacon
t=180-v
la=90-t; lo=036; y7 =sin(la); w=cos(la); x7 =sin(lo)*w; z7 =cos(lo)*w
la=90-t; lo=108; y8 =sin(la); w=cos(la); x8 =sin(lo)*w; z8 =cos(lo)*w
la=90-t; lo=180; y9 =sin(la); w=cos(la); x9 =sin(lo)*w; z9 =cos(lo)*w
la=90-t; lo=252; y10=sin(la); w=cos(la); x10=sin(lo)*w; z10=cos(lo)*w
la=90-t; lo=324; y11=sin(la); w=cos(la); x11=sin(lo)*w; z11=cos(lo)*w
t=180
la=90-t; lo=000; y12=sin(la); w=cos(la); x12=sin(lo)*w; z12=cos(lo)*w

// triacon points
u=tt-uu
la=90-u; lo=036; yc2=sin(la); w=cos(la); xc2=sin(lo)*w; zc2=cos(lo)*w
la=90-u; lo=108; yc3=sin(la); w=cos(la); xc3=sin(lo)*w; zc3=cos(lo)*w
la=90-u; lo=180; yc4=sin(la); w=cos(la); xc4=sin(lo)*w; zc4=cos(lo)*w
la=90-u; lo=252; yc5=sin(la); w=cos(la); xc5=sin(lo)*w; zc5=cos(lo)*w
la=90-u; lo=324; yc6=sin(la); w=cos(la); xc6=sin(lo)*w; zc6=cos(lo)*w
u=tt+uu
la=90-u; lo=036; yc12=sin(la); w=cos(la); xc12=sin(lo)*w; zc12=cos(lo)*w
la=90-u; lo=108; yc13=sin(la); w=cos(la); xc13=sin(lo)*w; zc13=cos(lo)*w
la=90-u; lo=180; yc14=sin(la); w=cos(la); xc14=sin(lo)*w; zc14=cos(lo)*w
la=90-u; lo=252; yc15=sin(la); w=cos(la); xc15=sin(lo)*w; zc15=cos(lo)*w
la=90-u; lo=324; yc16=sin(la); w=cos(la); xc16=sin(lo)*w; zc16=cos(lo)*w
u=180-tt-uu
la=90-u; lo=000; yc22=sin(la); w=cos(la); xc22=sin(lo)*w; zc22=cos(lo)*w
la=90-u; lo=072; yc23=sin(la); w=cos(la); xc23=sin(lo)*w; zc23=cos(lo)*w
la=90-u; lo=144; yc24=sin(la); w=cos(la); xc24=sin(lo)*w; zc24=cos(lo)*w
la=90-u; lo=216; yc25=sin(la); w=cos(la); xc25=sin(lo)*w; zc25=cos(lo)*w
la=90-u; lo=288; yc26=sin(la); w=cos(la); xc26=sin(lo)*w; zc26=cos(lo)*w
u=180-tt+uu
la=90-u; lo=000; yc32=sin(la); w=cos(la); xc32=sin(lo)*w; zc32=cos(lo)*w
la=90-u; lo=072; yc33=sin(la); w=cos(la); xc33=sin(lo)*w; zc33=cos(lo)*w
la=90-u; lo=144; yc34=sin(la); w=cos(la); xc34=sin(lo)*w; zc34=cos(lo)*w
la=90-u; lo=216; yc35=sin(la); w=cos(la); xc35=sin(lo)*w; zc35=cos(lo)*w
la=90-u; lo=288; yc36=sin(la); w=cos(la); xc36=sin(lo)*w; zc36=cos(lo)*w

//
// p=pyth(x1+x2+x3,y1+y2+y3,z1+z2+z3,1); xc2=x1+x2+x3/p; yc2=y1+y2+y3/p; zc2=z1+z2+z3/p;
// p=pyth(x1+x3+x4,y1+y3+y4,z1+z3+z4,1);xc3=x1+x3+x4/p; yc3=y1+y3+y4/p; zc3=z1+z3+z4/p;
set facet_data on
geo_trixyz (' 1  c2  c3')
set facet_data off
// facet_data ("iso triacon facet",x1,y1,z1,xc2,yc2,zc2,xc3,yc3,zc3)
if one_unit_only; object_attributes(); end
geo_trixyz (' 1  c3  c4')
geo_trixyz (' 1  c4  c5')
geo_trixyz (' 1  c5  c6')
geo_trixyz (' 1  c6  c2')
$ // end triacon tops

$ // mid upper
geo_trixyz (' 3  c2  c3')
geo_trixyz (' 4  c3  c4')
geo_trixyz (' 5  c4  c5')
geo_trixyz (' 6  c5  c6')
geo_trixyz (' 2  c6  c2')
$ //
geo_trixyz (' 2  c12 c2')
geo_trixyz (' 3  c13 c3')
geo_trixyz (' 4  c14 c4')
geo_trixyz (' 5  c15 c5')
geo_trixyz (' 6  c16 c6')
$ //
geo_trixyz (' 3  c12 c2')
geo_trixyz (' 4  c13 c3')
geo_trixyz (' 5  c14 c4')
geo_trixyz (' 6  c15 c5')
geo_trixyz (' 2  c16 c6')
$ //

// triacon calcs for lower mid triangles
geo_trixyz (' 2  c22 c12')
geo_trixyz (' 3  c23 c13')
geo_trixyz (' 4  c24 c14')
geo_trixyz (' 5  c25 c15')
geo_trixyz (' 6  c26 c16')
$ //
geo_trixyz (' 2  c22 c16')
geo_trixyz (' 3  c23 c12')
geo_trixyz (' 4  c24 c13')
geo_trixyz (' 5  c25 c14')
geo_trixyz (' 6  c26 c15')
$ //
geo_trixyz (' 7  c22 c12')
geo_trixyz (' 8  c23 c13')
geo_trixyz (' 9  c24 c14')
geo_trixyz ('10  c25 c15')
geo_trixyz ('11  c26 c16')
$ //
geo_trixyz (' 7  c23 c12')
geo_trixyz (' 8  c24 c13')
geo_trixyz (' 9  c25 c14')
geo_trixyz ('10  c26 c15')
geo_trixyz ('11  c22 c16')
$ //
geo_trixyz (' 7  c22 c32')
geo_trixyz (' 8  c23 c33')
geo_trixyz (' 9  c24 c34')
geo_trixyz ('10  c25 c35')
geo_trixyz ('11  c26 c36')
$ //
geo_trixyz ('11  c22 c32')
geo_trixyz (' 7  c23 c33')
geo_trixyz (' 8  c24 c34')
geo_trixyz (' 9  c25 c35')
geo_trixyz ('10  c26 c36')
$ //
$ //bottom triacons
geo_trixyz (' 7  c32 c33')
geo_trixyz (' 8  c33 c34')
geo_trixyz (' 9  c34 c35')
geo_trixyz ('10  c35 c36')
geo_trixyz ('11  c36 c32')
$ //
geo_trixyz ('12  c32 c33')
geo_trixyz ('12  c33 c34')
geo_trixyz ('12  c34 c35')
geo_trixyz ('12  c35 c36')
geo_trixyz ('12  c36 c32')
$ //
$ // end triacon
$ //
object_attributes ()
end



def geo_icosahedron_xyz
new v,w,lo,la,t,r,c,n,f
new x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12
new y1,y2,y3,y4,y5,y6,y7,y8,y9,y10,y11,y12
new z1,z2,z3,z4,z5,z6,z7,z8,z9,z10,z11,z12
//$ #declare geodesic =
$ // Icosahedron
//$ union {
v=atn(2) // great arc for side of icos face = 63.43... degrees
t=atan( 2*cos(36),1 )*2 // napier rules: cos A =  tan b / tan c
// centre of sphere x=0,y=0,z=0
la=90  ; lo=000; y1=sin(la); w=cos(la); x1=sin(lo)*w; z1=cos(lo)*w
//
r=strut_size
n=isoc
la=90-v; lo=000; y2=sin(la); w=cos(la); x2=sin(lo)*w; z2=cos(lo)*w
la=90-v; lo=072; y3=sin(la); w=cos(la); x3=sin(lo)*w; z3=cos(lo)*w
la=90-v; lo=144; y4=sin(la); w=cos(la); x4=sin(lo)*w; z4=cos(lo)*w
la=90-v; lo=216; y5=sin(la); w=cos(la); x5=sin(lo)*w; z5=cos(lo)*w
la=90-v; lo=288; y6=sin(la); w=cos(la); x6=sin(lo)*w; z6=cos(lo)*w
$ //
la=90-t; lo=036; y7=sin(la); w=cos(la); x7=sin(lo)*w; z7=cos(lo)*w
la=90-t; lo=108; y8=sin(la); w=cos(la); x8=sin(lo)*w; z8=cos(lo)*w
la=90-t; lo=180; y9=sin(la); w=cos(la); x9=sin(lo)*w; z9=cos(lo)*w
la=90-t; lo=252; y10=sin(la); w=cos(la); x10=sin(lo)*w; z10=cos(lo)*w
la=90-t; lo=324; y11=sin(la); w=cos(la); x11=sin(lo)*w; z11=cos(lo)*w
t=180
la=-90 ; lo=000; y12=sin(la); w=cos(la); x12=sin(lo)*w; z12=cos(lo)*w
c=divisions // recursion level
f=power(2,c); if division_3f; f=f*1.5 // geodesic frequency
// top
set facet_data on
geo_trixyz ('1 2 3',r,n,c)
set facet_data off
if one_unit_only; object_attributes(); end
// facet_data ("isos facet",x1,y1,z1,x2,y2,z2,x3,y3,z3)
geo_trixyz ('1 3 4')
geo_trixyz ('1 4 5')
geo_trixyz ('1 5 6')
geo_trixyz ('1 6 2')
// upper middle
geo_trixyz ('7 2 3')
geo_trixyz ('8 3 4')
geo_trixyz ('9 4 5')
geo_trixyz ('10 5 6')
geo_trixyz ('11 6 2')
// lower middle
geo_trixyz ('3 7 8 ')
geo_trixyz ('4 8 9 ')
geo_trixyz ('5 9 10')
geo_trixyz ('6 10 11')
geo_trixyz ('2 11 7 ')
// bottom
if not hemi
geo_trixyz ('12 7 8 ')
geo_trixyz ('12 8 9 ')
geo_trixyz ('12 9 10')
geo_trixyz ('12 10 11')
geo_trixyz ('12 11 7 ')
endif
//
object_attributes ()
end

def geo_octahedron_xyz
new w,lo,la,t,r,c,n,f
new x1,x2,x3,x4,x5,x6,y1,y2,y3,y4,y5,y6,z1,z2,z3,z4,z5,z6
//$ #declare geodesic =
$ // octahedron
//$ union {
// centre of sphere x=0,y=0,z=0
la=90;lo=000; y1=sin(la); w=cos(la); x1=sin(lo)*w; z1=cos(lo)*w
la=0; lo=000; y2=sin(la); w=cos(la); x2=sin(lo)*w; z2=cos(lo)*w
la=0; lo=090; y3=sin(la); w=cos(la); x3=sin(lo)*w; z3=cos(lo)*w
la=0; lo=180; y4=sin(la); w=cos(la); x4=sin(lo)*w; z4=cos(lo)*w
la=0; lo=270; y5=sin(la); w=cos(la); x5=sin(lo)*w; z5=cos(lo)*w
la=-90; lo=0; y6=sin(la); w=cos(la); x6=sin(lo)*w; z6=cos(lo)*w

r=strut_size
n=isoc
c=divisions // recursion level
f=power(2,c) // geodesic frequency

// top
geo_triangle (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
geo_triangle (x1,y1,z1,x3,y3,z3,x4,y4,z4,r,n,c)
geo_triangle (x1,y1,z1,x4,y4,z4,x5,y5,z5,r,n,c)
geo_triangle (x1,y1,z1,x5,y5,z5,x2,y2,z2,r,n,c)
// bottom
geo_triangle (x6,y6,z6,x2,y2,z2,x3,y3,z3,r,n,c)
geo_triangle (x6,y6,z6,x3,y3,z3,x4,y4,z4,r,n,c)
geo_triangle (x6,y6,z6,x4,y4,z4,x5,y5,z5,r,n,c)
geo_triangle (x6,y6,z6,x5,y5,z5,x2,y2,z2,r,n,c)
//
object_attributes ()
end

def geo_triacon_octahedron_xyz
new w,lo,la,t,r,c,n,f
new x1,x2,x3,x4,x5,x6,y1,y2,y3,y4,y5,y6,z1,z2,z3,z4,z5,z6
new x11,x12,x13,x14,x15,x16,y11,y12,y13,y14,y15,y16,z11,z12,z13,z14,z15,z16
new x21,x22,x23,x24,x25,x26,y21,y22,y23,y24,y25,y26,z21,z22,z23,z24,z25,z26

//$ #declare geodesic =
$ // octahedron
//$ union {
// centre of sphere x=0,y=0,z=0
la=90;lo=000; y1=sin(la); w=cos(la); x1=sin(lo)*w; z1=cos(lo)*w
la=0; lo=000; y2=sin(la); w=cos(la); x2=sin(lo)*w; z2=cos(lo)*w
la=0; lo=090; y3=sin(la); w=cos(la); x3=sin(lo)*w; z3=cos(lo)*w
la=0; lo=180; y4=sin(la); w=cos(la); x4=sin(lo)*w; z4=cos(lo)*w
la=0; lo=270; y5=sin(la); w=cos(la); x5=sin(lo)*w; z5=cos(lo)*w
la=-90; lo=0; y6=sin(la); w=cos(la); x6=sin(lo)*w; z6=cos(lo)*w
new u=atn(1*sin(45))
// triacon split
la=u; lo=045; y12=sin(la); w=cos(la); x12=sin(lo)*w; z12=cos(lo)*w
la=u; lo=135; y13=sin(la); w=cos(la); x13=sin(lo)*w; z13=cos(lo)*w
la=u; lo=225; y14=sin(la); w=cos(la); x14=sin(lo)*w; z14=cos(lo)*w
la=u; lo=315; y15=sin(la); w=cos(la); x15=sin(lo)*w; z15=cos(lo)*w
u=-u
la=u; lo=045; y22=sin(la); w=cos(la); x22=sin(lo)*w; z22=cos(lo)*w
la=u; lo=135; y23=sin(la); w=cos(la); x23=sin(lo)*w; z23=cos(lo)*w
la=u; lo=225; y24=sin(la); w=cos(la); x24=sin(lo)*w; z24=cos(lo)*w
la=u; lo=315; y25=sin(la); w=cos(la); x25=sin(lo)*w; z25=cos(lo)*w

r=strut_size
n=isoc
c=divisions // recursion level
f=power(2,c) // geodesic frequency

// triacon
geo_triangle (x1,y1,z1,x12,y12,z12,x13,y13,z13,r,n,c)
geo_triangle (x1,y1,z1,x13,y13,z13,x14,y14,z14,r,n,c)
geo_triangle (x1,y1,z1,x14,y14,z14,x15,y15,z15,r,n,c)
geo_triangle (x1,y1,z1,x15,y15,z15,x12,y12,z12,r,n,c)
// reflect x
geo_triangle (x3,y3,z3,x12,y12,z12,x13,y13,z13,r,n,c)
geo_triangle (x4,y4,z4,x13,y13,z13,x14,y14,z14,r,n,c)
geo_triangle (x5,y5,z5,x14,y14,z14,x15,y15,z15,r,n,c)
geo_triangle (x2,y2,z2,x15,y15,z15,x12,y12,z12,r,n,c)

// mid diamond
geo_triangle (x2,y2,z2,x12,y12,z12,x22,y22,z22,r,n,c)
geo_triangle (x3,y3,z3,x13,y13,z13,x23,y23,z23,r,n,c)
geo_triangle (x4,y4,z4,x14,y14,z14,x24,y24,z24,r,n,c)
geo_triangle (x5,y5,z5,x15,y15,z15,x25,y25,z25,r,n,c)
// reflect y
geo_triangle (x3,y3,z3,x12,y12,z12,x22,y22,z22,r,n,c)
geo_triangle (x4,y4,z4,x13,y13,z13,x23,y23,z23,r,n,c)
geo_triangle (x5,y5,z5,x14,y14,z14,x24,y24,z24,r,n,c)
geo_triangle (x2,y2,z2,x15,y15,z15,x25,y25,z25,r,n,c)

// lower diamond
geo_triangle (x3,y3,z3,x22,y22,z22,x23,y23,z23,r,n,c)
geo_triangle (x4,y4,z4,x23,y23,z23,x24,y24,z24,r,n,c)
geo_triangle (x5,y5,z5,x24,y24,z24,x25,y25,z25,r,n,c)
geo_triangle (x2,y2,z2,x25,y25,z25,x22,y22,z22,r,n,c)

// bottom
geo_triangle (x6,y6,z6,x22,y22,z22,x23,y23,z23,r,n,c)
geo_triangle (x6,y6,z6,x23,y23,z23,x24,y24,z24,r,n,c)
geo_triangle (x6,y6,z6,x24,y24,z24,x25,y25,z25,r,n,c)
geo_triangle (x6,y6,z6,x25,y25,z25,x22,y22,z22,r,n,c)
object_attributes ()
end

def geo_diamond (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
r=r*strut_size_reduction
new xc=x1+x2+x3 /3
new yc=y1+y2+y3 /3
new zc=z1+z2+z3 /3

if iso_diamond
 // locate perpendiculars from center
 new a1=pyth(x2-x1,y2-y1,z2-z1,1)
 new a2=pyth(x3-x2,y3-y2,z3-z2,1)
 new a3=pyth(x1-x3,y1-y3,z1-z3,1)
 new xt1=x1+x2/2, yt1=y1+y2/2, zt1=z1+z2/2
 new xt2=x2+x3/2, yt2=y2+y3/2, zt2=z2+z3/2
 new xt3=x1+x3/2, yt3=y1+y3/2, zt3=z1+z3/2
 new A=asin(sin(a2/2)/sin(a1))
 new c=atan(tan(a1/2),cos(A))
 new t=atan(tan(a1)*cos(A),1)
 new w=t-c
 t/2
 // partial_chord see kite
 new q=tan(t)-tan(t-w)/tan(t)/2 // chord ratio
 xc=x1-xt2*q+xt2; yc=y1-yt2*q+yt2; zc=z1-zt2*q+zt2
endif
new p
p=1/pyth(xc,yc,zc,1);xc=xc*p; yc=yc*p; zc=zc*p // sphere point

// new method assuming adjacent iso triangles
new cordx=pyth(x2-x1,y2-y1,z2-z1,1)
new xt=x1+x2/2, yt=y1+y2/2, zt=z1+z2/2
p=1/pyth(xt,yt,zt,1); xt*p;yt*p;zt*p 
new cordi=pyth(xt-xc,yt-yc,zt-zc,1)
new ca=2*asin(cordi/2), xa=asin(cordx/2)
p=cos(xa)/cos(ca); xc*p; yc*p; zc*p
say "diamond spf [p]"

if facet_data
 say ""
 say "----- triangle [tally]"
 say ""
 say "radius [dome_radius]"
 say "half diamond left side [tally]"
 facet_data ("",xc,yc,zc,x1,y1,z1,x2,y2,z2)
 say ""
 say "half diamond right side [tally]"
 facet_data ("",xc,yc,zc,x3,y3,z3,x1,y1,z1)
 say ""
 say "half diamond base side [tally]"
 facet_data ("",xc,yc,zc,x2,y2,z2,x3,y3,z3)
endif

$ // diamond
new q
if small_openings
 new cordc=pyth(x1-xc,y1-yc,z1-zc,1)
 new dw=tan(ca)*cos(xa)
 new da=atan(dw,cordx/2)
 q=small_openings; p=q*cos(da)*cordc/cordx
 new x11=x2-x1*p+x1, y11=y2-y1*p+y1, z11=z2-z1*p+z1
 new x12=x1-x2*p+x2, y12=y1-y2*p+y2, z12=z1-z2*p+z2
 new x21=x3-x2*p+x2, y21=y3-y2*p+y2, z21=z3-z2*p+z2
 new x22=x2-x3*p+x3, y22=y2-y3*p+y3, z22=z2-z3*p+z3
 new x31=x1-x3*p+x3, y31=y1-y3*p+y3, z31=z1-z3*p+z3
 new x32=x3-x1*p+x1, y32=y3-y1*p+y1, z32=z3-z1*p+z1

 new xc1=xc-x1 *q +x1
 new yc1=yc-y1 *q +y1
 new zc1=zc-z1 *q +z1
 new xc2=xc-x2 *q +x2
 new yc2=yc-y2 *q +y2
 new zc2=zc-z2 *q +z2
 new xc3=xc-x3 *q +x3
 new yc3=yc-y3 *q +y3
 new zc3=zc-z3 *q +z3
 $ union {
 strut (xc,yc,zc,xc1,yc1,zc1)
 strut (xc,yc,zc,xc2,yc2,zc2)
 strut (xc,yc,zc,xc3,yc3,zc3)
 //
 strut (x11,y11,z11,xc1,yc1,zc1)
 strut (x32,y32,z32,xc1,yc1,zc1)
 strut (x12,y12,z12,xc2,yc2,zc2)
 strut (x21,y21,z21,xc2,yc2,zc2)
 strut (x22,y22,z22,xc3,yc3,zc3)
 strut (x31,y31,z31,xc3,yc3,zc3)
 [strut_texture]
 $ }
 if membrane
  if not kite
   $ // membrane
   $ union {
   tri ('c c1 11 }'); tri ('c 11 12 }'); tri ('c 12 c2 }')
   tri ('c c2 21 }'); tri ('c 21 22 }'); tri ('c 22 c3 }')
   tri ('c c3 31 }'); tri ('c 31 32 }'); tri ('c 32 c1 }')
   [membrane_texture]
   $ }
   if inner_wall
    p=dome_radius - wall_thickness / dome_radius
    $ union {
    inner_wall_o ( xc1,yc1,zc1,x11,y11,z11 ,xc,yc,zc )
    inner_wall   ( x11,y11,z11,x12,y12,z12 ,xc,yc,zc )
    inner_wall_o ( xc2,yc2,zc2,x12,y12,z12 ,xc,yc,zc )

    inner_wall_o ( xc2,yc2,zc2,x21,y21,z21 ,xc,yc,zc )
    inner_wall   ( x21,y21,z21,x22,y22,z22 ,xc,yc,zc )
    inner_wall_o ( xc3,yc3,zc3,x22,y22,z22 ,xc,yc,zc )

    inner_wall_o ( xc3,yc3,zc3,x31,y31,z31 ,xc,yc,zc )
    inner_wall   ( x31,y31,z31,x32,y32,z32 ,xc,yc,zc )
    inner_wall_o ( xc1,yc1,zc1,x32,y32,z32 ,xc,yc,zc )

    [inner_wall_texture]
    $ }
   endif
   if glazing
    new xg,yg,zg,xi,yi,zi,p,a,q
    $ union {
    xi=x11;yi=y11; zi=z11
    q=pyth(xi,yi,zi,1)
    xg=x1*q;yg=y1*q;zg=z1*q; p=pyth(xi-xg,yi-yg,zi-zg,1); a=asin(p/2)*2; p=cos(a); xg*p; yg*p; zg*p
    trin ('11 c1 g }'); trin ('c1 32 g }')
    xi=x21;yi=y21; zi=z21
    q=pyth(xi,yi,zi,1)
    xg=x2*q;yg=y2*q;zg=z2*q; p=pyth(xi-xg,yi-yg,zi-zg,1); a=asin(p/2)*2; p=cos(a); xg*p; yg*p; zg*p
    trin ('12 c2 g }'); trin ('c2 21 g }')
    xi=x31;yi=y31; zi=z31
    q=pyth(xi,yi,zi,1) 
    xg=x3*q;yg=y3*q;zg=z3*q; p=pyth(xi-xg,yi-yg,zi-zg,1); a=asin(p/2)*2; p=cos(a); xg*p; yg*p; zg*p
    trin ('22 c3 g }'); trin ('c3 31 g }')
    [glazing_texture]
    $ }
   endif
  endif
 endif
else
 $ union {
 strut (x1,y1,z1,xc,yc,zc)
 strut (x2,y2,z2,xc,yc,zc)
 strut (x3,y3,z3,xc,yc,zc)
 [strut_texture]
 $ }
 if membrane
  if not kite
   $ // membrane
   $ union {
   tri ('1 2 c }'); tri ('2 3 c }'); tri ('1 3 c }')
   [membrane_texture]
   $ }
  endif
 endif
endif

end

def geo_trunc (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
new p=small_openings /2
new x11=x2-x1 *p+x1, y11=y2-y1 *p+y1, z11=z2-z1 *p+z1
new x12=x1-x2 *p+x2, y12=y1-y2 *p+y2, z12=z1-z2 *p+z2
new x21=x3-x2 *p+x2, y21=y3-y2 *p+y2, z21=z3-z2 *p+z2
new x22=x2-x3 *p+x3, y22=y2-y3 *p+y3, z22=z2-z3 *p+z3
new x31=x1-x3 *p+x3, y31=y1-y3 *p+y3, z31=z1-z3 *p+z3
new x32=x3-x1 *p+x1, y32=y3-y1 *p+y1, z32=z3-z1 *p+z1
// no spr ?
new xc=x1+x2+x3/3, yc=y1+y2+y3/3, zc=z1+z2+z3/3
$ union {
 if
  sticks ( x11,y11,z11,x12,y12,z12, .5, 1 )
  sticks ( x12,y12,z12,x21,y21,z21, .5, 1 )
  sticks ( x21,y21,z21,x22,y22,z22, .5, 1 )
  sticks ( x22,y22,z22,x31,y31,z31, .5, 1 )
  sticks ( x31,y31,z31,x32,y32,z32, .5, 1 )
  sticks ( x32,y32,z32,x11,y11,z11, .5, 1 )
 endif
strut (x11,y11,z11,x12,y12,z12)
strut (x12,y12,z12,x21,y21,z21)
strut (x21,y21,z21,x22,y22,z22)
strut (x22,y22,z22,x31,y31,z31)
strut (x31,y31,z31,x32,y32,z32)
strut (x32,y32,z32,x11,y11,z11)
[strut_texture]
$ }
//
if membrane
 new xc=x1+x2+x3 /3, yc=y1+y2+y3 /3, zc=z1+z2+z3 /3
 $ // membrane excl openings
 $ union {
 tri ('11 32 c }'); tri ('11 12 c }')
 tri ('12 21 c }'); tri ('21 22 c }')
 tri ('22 31 c }'); tri ('31 32 c }')
 $// membrane texture
 [membrane_texture]
 $ }
 if inner_wall
  p=dome_radius - wall_thickness / dome_radius
  $ union {
  inner_wall_o ( x11,y11,z11,x32,y32,z32 ,xc,yc,zc )
  inner_wall_o ( x12,y12,z12,x21,y21,z21 ,xc,yc,zc )
  inner_wall_o ( x22,y22,z22,x31,y31,z31 ,xc,yc,zc )

  inner_wall ( x11,y11,z11,x12,y12,z12 ,xc,yc,zc )
  inner_wall ( x21,y21,z21,x22,y22,z22 ,xc,yc,zc )
  inner_wall ( x31,y31,z31,x32,y32,z32 ,xc,yc,zc )
  [inner_wall_texture]
  $ }
  if glazing // geo_trunc
   new xg,yg,zg,xi,yi,zi,p,a,q
   $ union {
   xi=x11;yi=y11; zi=z11
   q=pyth(xi,yi,zi,1)
   xg=x1*q;yg=y1*q;zg=z1*q; p=pyth(xi-xg,yi-yg,zi-zg,1); a=asin(p/2)*2; p=cos(a); xg*p; yg*p; zg*p
   trin ('11 32 g }')
   xi=x21;yi=y21; zi=z21
   q=pyth(xi,yi,zi,1)
   xg=x2*q;yg=y2*q;zg=z2*q; p=pyth(xi-xg,yi-yg,zi-zg,1); a=asin(p/2)*2; p=cos(a); xg*p; yg*p; zg*p
   trin ('12 21 g }')
   xi=x31;yi=y31; zi=z31
   q=pyth(xi,yi,zi,1)
   xg=x3*q;yg=y3*q;zg=z3*q; p=pyth(xi-xg,yi-yg,zi-zg,1); a=asin(p/2)*2; p=cos(a); xg*p; yg*p; zg*p
   trin ('22 31 g }')
   [glazing_texture]
   $ }
  endif
 endif
endif
end

def iso_div (cen,isoc)
new a,b,c
new p,q,t,w
a=pyth(x2-x1,y2-y1,z2-z1,1)
b=pyth(x3-x2,y3-y2,z3-z2,1)
c=pyth(x1-x3,y1-y3,z1-z3,1)
if "[a]"="[b]" // base c
 set xt3=x1+x3/2; yt3=y1+y3/2; zt3=z1+z3/2
 t=asin(a/2); w=asin(c/2)
 q=tan(t)-tan(t-w)/tan(t)/2 // express as chord ratio
 set xt1=x2-x1*q+x1; yt1=y2-y1*q+y1; zt1=z2-z1*q+z1
 set xt2=x2-x3*q+x3; yt2=y2-y3*q+y3; zt2=z2-z3*q+z3
elseif "[a]"="[c]" // base b
 set xt2=x2+x3/2; yt2=y2+y3/2; zt2=z2+z3/2
 t=asin(a/2); w=asin(b/2)
 q=tan(t)-tan(t-w)/tan(t)/2 // express as chord ratio
 set xt1=x1-x2*q+x2; yt1=y1-y2*q+y2; zt1=z1-z2*q+z2
 set xt3=x1-x3*q+x3; yt3=y1-y3*q+y3; zt3=z1-z3*q+z3
elseif "[b]"="[c]" // base a
 set xt1=x1+x2/2; yt1=y1+y2/2; zt1=z1+z2/2
 t=asin(b/2); w=asin(a/2)
 q=tan(t)-tan(t-w)/tan(t)/2 // express as chord ratio
 set xt3=x3-x1*q+x1; yt3=y3-y1*q+y1; zt3=z3-z1*q+z1
 set xt2=x3-x2*q+x2; yt2=y3-y2*q+y2; zt2=z3-z2*q+z2
else // if not ("[a]"="[b]") or ("[b]"="[c]") or ("[a]"="[c]")
 // Beep()
 say "asymmetric triangle [tally] = '[a], b[b], c[c] ";isoc=3
endif
if isoc>2
 // say "mean division"
 set xt1=x1+x2/2;yt1=y1+y2/2;zt1=z1+z2/2
 set xt2=x2+x3/2;yt2=y2+y3/2;zt2=z2+z3/2
 set xt3=x3+x1/2;yt3=y3+y1/2;zt3=z3+z1/2
else
 // say "isometric division"
endif
// raise sphere points
set p=1/pyth(xt1,yt1,zt1,1); xt1*p; yt1*p; zt1*p
set p=1/pyth(xt2,yt2,zt2,1); xt2*p; yt2*p; zt2*p
set p=1/pyth(xt3,yt3,zt3,1); xt3*p; yt3*p; zt3*p
if cen=0; end
// find centre point
if isoc<3
 new aa,hh,ch
 new na=asin(a/2)*2, nb=asin(b/2)*2, nc=asin(c/2)*2
 if "[a]"="[b]" // base c
  hh=acos(cos(na)/cos(nc/2)); aa=asin(sin(hh)/sin(na)); ch=atn(tan(aa/2)*sin(nc/2))
  t=hh/2; w=ch; q=tan(t)-tan(t-w)/tan(t)/2 // chord ratio
  set xc=x2-xt3*q+xt3; yc=y2-yt3*q+yt3; zc=z2-zt3*q+zt3
  //say "base c hh=[hh] ch=[ch]"
 elseif "[a]"="[c]" // base b
  hh=acos(cos(na)/cos(nb/2)); aa=asin(sin(hh)/sin(na)); ch=atn(tan(aa/2)*sin(nb/2))
  t=hh/2; w=ch; q=tan(t)-tan(t-w)/tan(t)/2 // chord ratio
  set xc=x1-xt2*q+xt2; yc=y1-yt2*q+yt2; zc=z1-zt2*q+zt2
 elseif "[b]"="[c]" // base a
  hh=acos(cos(nb)/cos(na/2)); aa=asin(sin(hh)/sin(nb)); ch=atn(tan(aa/2)*sin(na/2))
  t=hh/2; w=ch; q=tan(t)-tan(t-w)/tan(t)/2 // chord ratio
  set xc=x3-xt1*q+xt1; yc=y3-yt1*q+yt1; zc=z3-zt1*q+zt1
 else
 isoc=3
 endif
endif
if isoc>2
 set xc=x1+x2+x3 /3; yc=y1+y2+y3 /3; zc=z1+z2+z3 /3
endif
//
set p=1/pyth(xc,yc,zc,1); xc*p; yc*p; zc*p
if cen<2; end
if isoc<3
 new ha,tt,tw
 if "[a]"="[b]" // base c
  t=nc/2; tt=tan(t)
  ha=atn(tt/sin(ch)) /2; tw=tan(ha)*sin(ch); w=atn(tw)
  q=tt-tw/tt/2; p=tw/tt +q // chord ratios
  set xt31=x1-x3*q+x3; yt31=y1-y3*q+y3; zt31=z1-z3*q+z3 
  set xt32=x1-x3*p+x3; yt32=y1-y3*p+y3; zt32=z1-z3*p+z3
  t=nb/2; tt=tan(t)
  q=tt-tw/tt/2; p=tw/tt +q // chord ratios
  set xt22=x2-x3*q+x3; yt22=y2-y3*q+y3; zt22=z2-z3*q+z3 
  set xt21=x2-x3*p+x3; yt21=y2-y3*p+y3; zt21=z2-z3*p+z3 
  set xt11=x2-x1*q+x1; yt11=y2-y1*q+y1; zt11=z2-z1*q+z1 
  set xt12=x2-x1*p+x1; yt12=y2-y1*p+y1; zt12=z2-z1*p+z1 
 elseif "[a]"="[c]" // base b
  t=nb/2; tt=tan(t)
  ha=atn(tt/sin(ch)) /2; tw=tan(ha)*sin(ch); w=atn(tw)
  q=tt-tw/tt/2; p=tw/tt +q // chord ratios
  set xt21=x3-x2*q+x2; yt21=y3-y2*q+y2; zt21=z3-z2*q+z2 
  set xt22=x3-x2*p+x2; yt22=y3-y2*p+y2; zt22=z3-z2*p+z2
  t=na/2; tt=tan(t)
  q=tt-tw/tt/2; p=tw/tt +q // chord ratios
  set xt31=x1-x3*q+x3; yt31=y1-y3*q+y3; zt31=z1-z3*q+z3 
  set xt32=x1-x3*p+x3; yt32=y1-y3*p+y3; zt32=z1-z3*p+z3 
  set xt12=x1-x2*q+x2; yt12=y1-y2*q+y2; zt12=z1-z2*q+z2 
  set xt11=x1-x2*p+x2; yt11=y1-y2*p+y2; zt11=z1-z2*p+z2 
 elseif "[b]"="[c]" // base a
  t=na/2; tt=tan(t)
  ha=atn(tt/sin(ch)) /2; tw=tan(ha)*sin(ch); w=atn(tw)
  q=tt-tw/tt/2; p=tw/tt +q // chord ratios
  set xt11=x2-x1*q+x1; yt11=y2-y1*q+y1; zt11=z2-z1*q+z1 
  set xt12=x2-x1*p+x1; yt12=y2-y1*p+y1; zt12=z2-z1*p+z1
  t=nb/2; tt=tan(t)
  q=tt-tw/tt/2; p=tw/tt +q // chord ratios
  set xt32=x3-x1*q+x1; yt32=y3-y1*q+y1; zt32=z3-z1*q+z1 
  set xt31=x3-x1*p+x1; yt31=y3-y1*p+y1; zt31=z3-z1*p+z1 
  set xt21=x3-x2*q+x2; yt21=y3-y2*q+y2; zt21=z3-z2*q+z2 
  set xt22=x3-x2*p+x2; yt22=y3-y2*p+y2; zt22=z3-z2*p+z2 
 else
  isoc=3
 endif
endif
if isoc>2
 q=.25; p=.75
 set xt31=x1-x3*q+x3; yt31=y1-y3*q+y3; zt31=z1-z3*q+z3 
 set xt32=x1-x3*p+x3; yt32=y1-y3*p+y3; zt32=z1-z3*p+z3 
 set xt21=x3-x2*q+x2; yt21=y3-y2*q+y2; zt21=z3-z2*q+z2 
 set xt22=x3-x2*p+x2; yt22=y3-y2*p+y2; zt22=z3-z2*p+z2
 set xt12=x1-x2*q+x2; yt12=y1-y2*q+y2; zt12=z1-z2*q+z2 
 set xt11=x1-x2*p+x2; yt11=y1-y2*p+y2; zt11=z1-z2*p+z2 
endif
// raise spherepoints
set p=1/pyth(xt11,yt11,zt11,1); xt11*p; yt11*p; zt11*p
set p=1/pyth(xt12,yt12,zt12,1); xt12*p; yt12*p; zt12*p
set p=1/pyth(xt21,yt21,zt21,1); xt21*p; yt21*p; zt21*p
set p=1/pyth(xt22,yt22,zt22,1); xt22*p; yt22*p; zt22*p
set p=1/pyth(xt31,yt31,zt31,1); xt31*p; yt31*p; zt31*p
set p=1/pyth(xt32,yt32,zt32,1); xt32*p; yt32*p; zt32*p
end


def geo_kite (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
r=r*strut_size_reduction
new p
p=1/pyth( x1+x2 /2, y1+y2 /2, z1+z2 /2,1)
new xt1=x1+x2 *p/2, yt1=y1+y2 *p/2, zt1=z1+z2 *p/2
p=1/pyth( x2+x3 /2, y2+y3 /2, z2+z3 /2,1)
new xt2=x2+x3 *p/2, yt2=y2+y3 *p/2, zt2=z2+z3 *p/2
p=1/pyth( x3+x1 /2, y3+y1 /2, z3+z1 /2,1)
new xt3=x3+x1 *p/2, yt3=y3+y1 *p/2, zt3=z3+z1 *p/2
new xc=x1+x2+x3 /3, yc=y1+y2+y3 /3, zc=z1+z2+z3 /3
if iso_kite
 n+1
 iso_div (1,n)
else
 set p=1/pyth(xc,yc,zc,1); xc*p; yc*p; zc*p
endif

$ // kite

// new method
new  xtt=xt1+xt2 /2
new  ytt=yt1+yt2 /2
new  ztt=zt1+zt2 /2
new cordt=pyth(xt2-xt1,yt2-yt1,zt2-zt1,1)
new cordc=pyth(x2-xc,y2-yc,z2-zc,1)
new angt=asin(cordt/2)
new angc=asin(cordc/2)
new ra=angt-angc
new la=90-angc
new lc= 1/tan(la)
new rc= 1/tan(ra)
new lb= lc/(lc+rc) * cordc
new ls= lb/cos(la)
p=1-ls
xc*p; yc*p; zc*p


if small_openings

 p=small_openings

 new x11=xt1-x1 *p+x1, y11=yt1-y1 *p+y1, z11=zt1-z1 *p+z1
 new x12=xt1-x2 *p+x2, y12=yt1-y2 *p+y2, z12=zt1-z2 *p+z2

 new x21=xt2-x2 *p+x2, y21=yt2-y2 *p+y2, z21=zt2-z2 *p+z2
 new x22=xt2-x3 *p+x3, y22=yt2-y3 *p+y3, z22=zt2-z3 *p+z3

 new x31=xt3-x3 *p+x3, y31=yt3-y3 *p+y3, z31=zt3-z3 *p+z3
 new x32=xt3-x1 *p+x1, y32=yt3-y1 *p+y1, z32=zt3-z1 *p+z1

 //
 $ union {
 strut (x11,y11,z11,xt1,yt1,zt1)
 strut (x12,y12,z12,xt1,yt1,zt1)
 strut (x21,y21,z21,xt2,yt2,zt2)
 strut (x22,y22,z22,xt2,yt2,zt2)
 strut (x31,y31,z31,xt3,yt3,zt3)
 strut (x32,y32,z32,xt3,yt3,zt3)
 //
 strut (x11,y11,z11,x32,y32,z32)
 strut (x12,y12,z12,x21,y21,z21)
 strut (x22,y22,z22,x31,y31,z31)
 [strut_texture]
 $ }
 //
 if membrane
  $ // membrane excl openings
  $ union {
  tri ('11 32 c }'); tri ('t1 11 c }'); tri ('t3 32 c }')
  tri ('12 21 c }'); tri ('t1 12 c }'); tri ('t2 21 c }')
  tri ('22 31 c }'); tri ('t2 22 c }'); tri ('t3 31 c }')
  $// membrane texture
  [membrane_texture]
  $ }
  if inner_wall
   p=dome_radius - wall_thickness / dome_radius
   $ union {
   inner_wall_o ( x11,y11,z11,x32,y32,z32 ,xc,yc,zc )
   inner_wall_o ( x12,y12,z12,x21,y21,z21 ,xc,yc,zc )
   inner_wall_o ( x22,y22,z22,x31,y31,z31 ,xc,yc,zc )
   //
   inner_wall ( xt1,yt1,zt1,x11,y11,z11 ,xc,yc,zc )
   inner_wall ( xt3,yt3,zt3,x32,y32,z32 ,xc,yc,zc )
   inner_wall ( xt1,yt1,zt1,x12,y12,z12 ,xc,yc,zc )
   inner_wall ( xt2,yt2,zt2,x21,y21,z21 ,xc,yc,zc )
   inner_wall ( xt2,yt2,zt2,x22,y22,z22 ,xc,yc,zc )
   inner_wall ( xt3,yt3,zt3,x31,y31,z31 ,xc,yc,zc )
   [inner_wall_texture]
   $ }
  endif
  if glazing
   new xg,yg,zg,xi,yi,zi,p,a,q
   $ union {
   xi=x11;yi=y11; zi=z11
   q=pyth(xi,yi,zi,1)
   xg=x1*q;yg=y1*q;zg=z1*q; p=pyth(xi-xg,yi-yg,zi-zg,1); a=asin(p/2)*2; p=cos(a); xg*p; yg*p; zg*p
   trin ('11 32 g }')
   xi=x21;yi=y21; zi=z21
   q=pyth(xi,yi,zi,1)
   xg=x2*q;yg=y2*q;zg=z2*q; p=pyth(xi-xg,yi-yg,zi-zg,1); a=asin(p/2)*2; p=cos(a); xg*p; yg*p; zg*p
   trin ('12 21 g }')
   xi=x31;yi=y31; zi=z31
   q=pyth(xi,yi,zi,1)
   xg=x3*q;yg=y3*q;zg=z3*q; p=pyth(xi-xg,yi-yg,zi-zg,1); a=asin(p/2)*2; p=cos(a); xg*p; yg*p; zg*p
   trin ('22 31 g }')
   [glazing_texture]
   $ }
  endif
 endif
endif
$ union { // struts
if not mesh or (small_openings>0)
 if pentk=0
  strut (x1,y1,z1,xt1,yt1,zt1)
  strut (x1,y1,z1,xt3,yt3,zt3)
 endif
 strut (x2,y2,z2,xt1,yt1,zt1)
 strut (x2,y2,z2,xt2,yt2,zt2)
 strut (x3,y3,z3,xt2,yt2,zt2)
 strut (x3,y3,z3,xt3,yt3,zt3)
endif
// Y struts
strut (xt1,yt1,zt1,xc,yc,zc)
strut (xt2,yt2,zt2,xc,yc,zc)
strut (xt3,yt3,zt3,xc,yc,zc)
[strut_texture]
$ }
if facet_data
 say ""
 say "----- triangle [tally]"
 say "radius [dome_radius]"
 say "top kite tri [tally]"
 facet_data ("kite top outer ",x1,y1,z1,xt1,yt1,zt1,xt3,yt3,zt3)
 facet_data ("kite top inner ",xc,yc,zc,xt1,yt1,zt1,xt3,yt3,zt3)
 say ""
 say "left kite tri [tally]"
 facet_data ("kite left outer ",x2,y2,z2,xt2,yt2,zt2,xt1,yt1,zt1)
 facet_data ("kite left inner ",xc,yc,zc,xt2,yt2,zt2,xt1,yt1,zt1)
 say ""
 say "right kite tri [tally]"
 facet_data ("kite right outer",x3,y3,z3,xt3,yt3,zt3,xt2,yt2,zt2)
 facet_data ("kite right inner",xc,yc,zc,xt3,yt3,zt3,xt2,yt2,zt2)
endif
if small_openings; end

if truss_level>0
 truss (x1,y1,z1,xt1,yt1,zt1,xt3,yt3,zt3,r,1/truss_size,truss_level)
 truss (x2,y2,z2,xt1,yt1,zt1,xt2,yt2,zt2,r,1/truss_size,truss_level)
 truss (x3,y3,z3,xt2,yt2,zt2,xt3,yt3,zt3,r,1/truss_size,truss_level)
endif

if membrane
 $ // membrane
 $ union {
 if pentk=0
  tri('1 t1 c }')
  tri('1 t3 c }')
 endif
 tri('2 t2 c }')
 tri('2 t1 c }')
 tri('3 t3 c }')
 tri('3 t2 c }')
 $//
 $// membrane texture
 [membrane_texture]
 $ }
endif
end

def inner_wall ( xt3,yt3,zt3,x31,y31,z31 ,xc,yc,zc )
inner_tri ( xt3*p,yt3*p,zt3*p,x31*p,y31*p,z31*p,xc*p,yc*p,zc*p )
end

def inner_wall_o ( xt3,yt3,zt3,x31,y31,z31 ,xc,yc,zc )
inner_tri ( xt3*p,yt3*p,zt3*p,x31*p,y31*p,z31*p,xc*p,yc*p,zc*p )
// window ledges
inner_tri ( xt3,yt3,zt3,x31,y31,z31 ,xt3*p,yt3*p,zt3*p )
inner_tri ( xt3*p,yt3*p,zt3*p,x31*p,y31*p,z31*p ,x31,y31,z31 )
end

def inner_wall_t ( xt3,yt3,zt3,x31,y31,z31 ,xc,yc,zc )
inner_tri ( xt3*p,yt3*p,zt3*p,x31*p,y31*p,z31*p,xc*p,yc*p,zc*p )
// panel edges
inner_tri ( xt3,yt3,zt3,x31,y31,z31 ,xt3*p,yt3*p,zt3*p )
inner_tri ( xt3*p,yt3*p,zt3*p,x31*p,y31*p,z31*p ,x31,y31,z31 )

inner_tri ( xc,yc,zc,x31,y31,z31 ,xc*p,yc*p,zc*p )
inner_tri ( xc*p,yc*p,zc*p,x31*p,y31*p,z31*p ,x31,y31,z31 )

inner_tri ( xt3,yt3,zt3,xc,yc,zc ,xt3*p,yt3*p,zt3*p )
inner_tri ( xt3*p,yt3*p,zt3*p,xc*p,yc*p,zc*p ,xc,yc,zc )
end

def inner_tri ( xt3,yt3,zt3,x31,y31,z31 ,xc,yc,zc )
tri ('t3 31 c }')
end

def 3freq_division (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
// calcs for 3 frequency division
if c<0; end ;// recursion level
r=r*strut_size_reduction
c-1; n+1
new xt11,yt11,zt11,xt12,yt12,zt12
new xt21,yt21,zt21,xt22,yt22,zt22
new xt31,yt31,zt31,xt32,yt32,zt32
new xc,yc,zc
iso_div(2,n)
if c=0; set pentt on 
geo_triangle (x1,y1,z1,xt11,yt11,zt11,xt32,yt32,zt32,r,n,c)    // top
geo_triangle (xt11,yt11,zt11,xt12,yt12,zt12,xc,yc,zc,r,n,c) // mid left
geo_triangle (xt32,yt32,zt32,xc,yc,zc,xt31,yt31,zt31,r,n,c) // mid right
geo_triangle (xc,yc,zc,xt11,yt11,zt11,xt32,yt32,zt32,r,n,c) // inv mid centre

geo_triangle (xt21,yt21,zt21,xt12,yt12,zt12,xc,yc,zc,r,n,c) // inv base left
geo_triangle (xt22,yt22,zt22,xc,yc,zc,xt31,yt31,zt31,r,n,c) // inv base right
geo_triangle (xc,yc,zc,xt21,yt21,zt21,xt22,yt22,zt22,r,n,c) // base centre

if c=0; set pentt on
geo_triangle (x2,y2,z2,xt21,yt21,zt21,xt12,yt12,zt12,r,n,c) // base left
if c=0; set pentt on
geo_triangle (x3,y3,z3,xt31,yt31,zt31,xt22,yt22,zt22,r,n,c) // base right

end

def geo_triangle (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
new p
if c=divisions
 set sector+1; $ // polyhedral sector #[sector]
 if division_3f; 3freq_division (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c); end
endif
r=r*strut_size_reduction
if c<=0
 set tally+1; $  // triangle #[tally]
 if hemi
  new d=max(divisions,1)
  new a=-0.5/ d
  if y1<a; end
  if y2<a; end
  if y3<a; end
 endif
 if primary
  if facet_data; facet_data ("primary #[tally]",x1,y1,z1,x2,y2,z2,x3,y3,z3)
  if (pent=1) .or. (pentt=0)
   $ union {
   strut (x1,y1,z1,x2,y2,z2)
   strut (x2,y2,z2,x3,y3,z3)
   strut (x3,y3,z3,x1,y1,z1)
   [strut_texture]
   $ }
  endif
  if node_size
   // hub
   new nr=r*node_size
   $ sphere { < [x1],[y1],[z1] >, [nr] }
   $ sphere { < [x2],[y2],[z2] >, [nr] }
   $ sphere { < [x3],[y3],[z3] >, [nr] }
  endif
  if membrane
   if not diamond or kite
    if  (pentt=1) .and. (pent=0)
     if glazing
      new xg,yg,zg,xi,yi,zi,a
      xi=x2;yi=y2;zi=z2
      xg=x1;yg=y1;zg=z1; p=pyth(xi-xg,yi-yg,zi-zg,1); a=asin(p/2)*2; p=cos(a); xg*p; yg*p; zg*p
      trin ('g 2 3 ')
      [glazing_texture]
      $ }
     endif
    else
     $ // membrane
     tri ('1 2 3 ')
     [membrane_texture]
     $ }
     $ //
     if inner_wall
      p=dome_radius - wall_thickness / dome_radius
      $ union {
      inner_wall_t ( x1,y1,z1,x2,y2,z2,x3,y3,z3 ) // poly
      [inner_wall_texture]
      $ }
     endif
    endif
   endif
  endif
 endif
 if diamond; c=1; geo_diamond (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
 if kite; c=1; geo_kite (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
 if trunc; c=1; geo_trunc (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
 if truncated_form
  new xs,ys,zs
  central_spherepoint ("1 2 3",1,r*0.8,&xs,&ys,&zs)
  truncated_point     ("1 2 3",1/3,r*0.8,&xs,&ys,&zs,1,0)
  end
 endif
 if mesh; c=1; geo_kite (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c) // imperfect
 if diamond or kite or mesh; end
 if truss_level>0; truss_triangle (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,1/truss_size,truss_level)
 set pentt off
 end
endif
c-1; n+1

new xt1,xt2,xt3,yt1,yt2,yt3,zt1,zt2,zt3
iso_div (0,n)
// recurse
if no pent; if c=0; set pentt on
geo_triangle (x1,y1,z1,xt1,yt1,zt1,xt3,yt3,zt3,r,n,c)    // top
if no pent; if c=0; set pentt on
geo_triangle (x2,y2,z2,xt2,yt2,zt2,xt1,yt1,zt1,r,n,c)    // left
if no pent; if c=0; set pentt on
geo_triangle (x3,y3,z3,xt3,yt3,zt3,xt2,yt2,zt2,r,n,c)    // right
//
geo_triangle (xt2,yt2,zt2,xt3,yt3,zt3,xt1,yt1,zt1,r,n,c) // centre
end

def truss (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
r=r*strut_size_reduction
new x12=x1+(x2-x1 /n)
new y12=y1+(y2-y1 /n)
new z12=z1+(z2-z1 /n)
new x13=x1+(x3-x1 /n)
new y13=y1+(y3-y1 /n)
new z13=z1+(z3-z1 /n)
struti (x12,y12,z12,x13,y13,z13)
[strut_texture]
$ }
c-1
if c>0
 truss_triangle (x1,y1,z1,x12,y12,z12,x13,y13,z13,r,n,c)
endif
end

def truss_triangle (x1,y1,z1,x2,y2,z2,x3,y3,z3,r,n,c)
c-1
if c<0
 if truss_membrane
  $ // membrane
  tri ('1 2 3 ')
  [truss_membrane_texture]
  $ }
 endif
 end
endif
r=r*strut_size_reduction
$ union {
new x12=x1+(x2-x1 /n)
new y12=y1+(y2-y1 /n)
new z12=z1+(z2-z1 /n)
new x13=x1+(x3-x1 /n)
new y13=y1+(y3-y1 /n)
new z13=z1+(z3-z1 /n)
strut (x12,y12,z12,x13,y13,z13)
new x21=x2+(x1-x2 /n)
new y21=y2+(y1-y2 /n)
new z21=z2+(z1-z2 /n)
new x23=x2+(x3-x2 /n)
new y23=y2+(y3-y2 /n)
new z23=z2+(z3-z2 /n)
strut (x21,y21,z21,x23,y23,z23)
new x31=x3+(x1-x3 /n)
new y31=y3+(y1-y3 /n)
new z31=z3+(z1-z3 /n)
new x32=x3+(x2-x3 /n)
new y32=y3+(y2-y3 /n)
new z32=z3+(z2-z3 /n)
strut (x31,y31,z31,x32,y32,z32)
[strut_texture]
$ } // end union
// recursion
truss_triangle (x1,y1,z1,x12,y12,z12,x13,y13,z13,r,n,c)
truss_triangle (x2,y2,z2,x21,y21,z21,x23,y23,z23,r,n,c)
truss_triangle (x3,y3,z3,x31,y31,z31,x32,y32,z32,r,n,c)
end

def asin (v)
return atan (v, pyth ( 1, v , -1 ))
end

def acos (v)
return atan ( pyth ( 1, v, -1 ),v)
end


def place_polygon (list,xc,yc,lat,long,ang)
// place polygon on surface of sphere
// given list of xyz coordinates and target latitude longitude and
// orientation about polygon reference point xc,yc
new a,l,i,w,  sa,sb,sc,la,lo, g=1,  xd,yd,zd
i=0; @2=1
loop
 w=word(na,0)
 if no w; exit
 i+1
 a=atan(y[w]-yc,x[w]-xc)-90+ang
 a=mod(a,360)
 l=pyth(x[i]-xc,y[i]-yc,1)
 sc=asin(l)
 sa=asin(sin(a)*l)
 if a>90; g=-g
 if a>270; g=-g
 sb=acos(cos(sc)/cos(sa))*g
 la=acos(cos(sa)*cos(lat-sb))
 lo=asin(sin(sa)/sin(la))+long
 polar_to_cartesian (&xd,&yd,&zd,la,lo,1)
 set x[w]=xd; y[w]=yd; z[w]=zd
endl
end

def fold_about_axis (list,x1,y1,z1,x2,y2,z2,ang)
new dome_radius=24
//$ #declare geodesic =
$ // folding test
//$ union {
// test data
new xt1=1,xt2=1,xt3=-1,xt4=-1,xb,xe
new yt1=1,yt2=1,yt3= 1,yt4= 1,yb,ye
new zt1=-1,zt2=1,zt3=1,zt4=-1,zb,ze
// ww.log
ang=-60
xb=xt1; yb=yt1; zb=zt1
xe=xt3; ye=yt3; ze=zt3
// triangle
ray_triangle ("t1 t2 t3")
$ texture { pigment { color rgbt <0.8,0.8,0.4,0.6> } }
$ }
rotate_about_axis ("t1 t3 t4",&xb,&yb,&zb,&xe,&ye,&ze,ang)
ray_triangle ("t1 t3 t4")
$ }
struti (xb,yb,zb,xe,ye,ze,.03)
$ texture { pigment { color rgbt <0.2,0.2,0.2,0.4> } }
$ }
object_attributes ()
say 'ok'
end

def ray_triangle (p)
@2=1
new t1=word(p,0), t2=word(p,0), t3=word(p,0)
new xt1=x[t1],yt1=y[t1],zt1=z[t1]
new xt2=x[t2],yt2=y[t2],zt2=z[t2]
new xt3=x[t3],yt3=y[t3],zt3=z[t3]
tri ('t1 t2 t3 ')
end

def rotate_about_axis (list,&xb,&yb,&zb,&xe,&ye,&ze,ang)
new w
new xp,yp,zp,xc,yc,zc,xd,yd,zd
new latc,longc,latp,longp,latd,longd,radc,radp
@2=1
loop
 w=word(list,0); if no w; exit // next point
 xp=x[w]; yp=y[w]; zp=z[w] // get point
 interpolate_centre ("b","e","c","p" ) // obtain axial rotation point
 cartesian_to_polar (xc-xb,yc-yb,zc-zb,&latc,&longc,&radc)
 cartesian_to_polar (xp-xb,yp-yb,zp-zb,&latp,&longp,&radp)
 if latp=latc; if longp=longc; reloop
 longd=longp-longc; latd=latp
 polar_rotate_about_axis (&latd,&longd,latc,ang)
 longd+longc
 polar_to_cartesian (&xd,&yd,&zd,latd,longd,radp)
 xd+xb; yd+yb; zd+zb
 set x[w]=xd; y[w]=yd; z[w]=zd
 // ww.log
 // geo.pov
 // num "###.###"
 // say 'p  x[xp] y[yp] z[zp]'
 // say 'd  x[xd] y[yd] z[zd]'
endl
end

 def interpolate_centre (b,e,c,p )
 new rr=pyth(x[e]-x[b],y[e]-y[b],z[e]-z[b],1) // axis length
 new rp=pyth(x[p]-x[b],y[p]-y[b],z[p]-z[b],1) // point offset
 new f=rp/rr // interpolation factor
 set x[c]=x[e]-x[b]*f+x[b]
 set y[c]=y[e]-y[b]*f+y[b]
 set z[c]=z[e]-z[b]*f+z[b]
 end

def cartesian_to_polar (x,y,z,lat,long,rad)
// lat set to 0 at north pole
set rad=pyth(x,y,z,1); long=atan(z,x)
if rad==0
 set lat=90
else
 set lat=acos(y/rad)
endif
end

def polar_to_cartesian (x,y,z,lat,long,rad)
new w=sin(lat)*rad
set x=cos(long)*w; z=sin(long)*w; y=cos(lat)*rad
end

def polar_rotate_about_axis ( c, A , ca, ro )
new a,b,ra,rA, sg=1,g=1
a=asin(sin(c)*sin(A))
b=acos(cos(c)/cos(a))
b-ca; if b<0; b=-b; sg=-1 // reflect
ra=acos(cos(a)*cos(b))
rA=asin(sin(a)/sin(ra))+(ro*sg)
a=asin(sin(ra)*sin(rA))
if rA> 90; g=-g // recover lost cosine polarity
if rA>270; g=-g
b=acos(cos(ra)/cos(a))*g
if sg<0
 b=ca-b
else
 b+ca
endif
set c=acos(cos(a)*cos(b))
set A=asin(sin(a)/sin(c))
end

def sticks (x1,y1,z1,x2,y2,z2,w,d)
new p=dome_radius+d / dome_radius
new x3=x2*p, y3=y2*p, z3=z2*p
new x4=x1*p, y4=y1*p, z4=z1*p
tri ('1 2 3 }')
tri ('1 4 3 }')
// need enlarged radius  to remove taper
p=w/2/dome_radius
p=0.1
new x5=xc-x3*p+x3, y5=yc-y3*p+y3, z5=zc-z3*p+z3 // x2 x3
new x6=xc-x4*p+x4, y6=yc-y4*p+y4, z6=zc-z4*p+z4 // x1 x4
tri ('4 3 5 }')
tri ('5 6 4 }')
p=w/2/dome_radius
p=0.1
new x7=xc-x2*p+x2, y7=yc-y2*p+y2, z7=zc-z2*p+z2 // x2 x5
new x8=xc-x1*p+x1, y8=yc-y1*p+y1, z8=zc-z1*p+z1 // x1 x6
tri ('5 6 8 }')
tri ('8 7 5 }')
end

def struti (x1,y1,z1,x2,y2,z2,rr=r)
$ cylinder { <[x1],[y1],[z1]>,<[x2],[y2],[z2]>,[rr]
do wstrut
end

def strut (x1,y1,z1,x2,y2,z2,rr=r)
$ cylinder { <[x1],[y1],[z1]>,<[x2],[y2],[z2]>,[rr] }
do wstrut
end

def wstrut
new s
if (y1>=0)or(y2>=0); MoveTo (hDc, x1*100+150,-z1*100+270); LineTo(hDc, x2*100+150,-z2*100+270) // xz view 
if (z1<=0)or(z2<=0); MoveTo (hDc, x1*100+150,-y1*100+490); LineTo(hDc, x2*100+150,-y2*100+490) // xy view 
channel(2); seek (qpt)
s='[x1]'+cr+'[y1]'+cr+'[z1]'+cr+'[x2]'+cr+'[y2]'+cr+'[z2]'+cr; put(s);set qpt+len(s)
channel(1)
end


new lat,long,rad
w/2; d/2
cartesian_to_polar (x2-x1,y2-y1,z2-z1,&lat,&long,&rad)
new p=rad+d/rad
lat=90-lat // zero at equator
$ box {
$ <0,-[d],-[w]>, <[rad],[d],[w]>
long=-long
lat=-lat
$ rotate [lat]*z
$ rotate [long]*y
$ translate <[x1],[y1],[z1]>
$ }
end

def triacon_data (s)
new icos,hicos,side,hbase=0,hapex=0,rr,bb
icos=atan(2,1)
hicos=icos /2
side= atan(tan(hicos), cos(36) )
hbase=asin(sin(36)*sin(side) )
rr=sin(side/2)*2
bb=sin(hbase)
hapex=asin(bb/rr)
say s
say "side [side] degrees"
say "half base [hbase] degrees"
say "side [rr] chord"
say "half base [bb] chord"
say "half apex angle [hapex] degrees"
say "disc fitting into icos triangle"
new hh=cos(hapex)*rr
new ci=cos(hapex)/(1/sin(hapex) +1)
new cr=ci*rr
say "height  [hh]"
say "max disc radius [cr]"
say "max disc radius as proportion of side [ci]"
end

def geo_trixyz (coords)
@2=1
new w1=word(coords,0), w2=word(coords,0), w3=word(coords,0)
geo_triangle (x[w1],y[w1],z[w1],x[w2],y[w2],z[w2],x[w3],y[w3],z[w3],r,n,c)
end

def gravel
$ // gravel
$ texture {
$ pigment {
$ granite
$ turbulence 0.5
$ color_map {
macro off
$ [ 0.0 color rgb < 0.8, 0.8, 0.85 > ]
$ [ 0.7 color rgb < 0.4, 0.4, 0.44 > ]
macro on
$ } // color_map
$ } // texture
new sc=0.5/dome_radius
$ normal { granite .9 scale [sc] }
$ finish { ambient .3 }
$ } // end texture
end

def grass
$ // grass
$ texture {
$ pigment {
$ agate
$ turbulence .7
$ color_map {
//
macro off
$ [ 0.0 color rgb < 0.2, 0.2, 0.1> ]
$ [ 0.2 color rgb < 0.7, 0.9, 0.6> ]
$ [ 0.9 color rgb < 0.4, 0.9, 0.5> ]
macro on
$ } // end color map
//
$ }  // end pigment
$ scale < .3, 3, .3 >
$ finish { ambient 0.2 }
new sc=0.15/dome_radius
$ normal { bumps 3.9 scale [sc] }
$ } // end texture
end

def mortar (size,cement)
$ texture {
$ pigment {
$ crackle
$ octaves 0
$ turbulence 0.2
$ color_map {
macro "()"
$ [ 0.0 (cement)  color rgb <.5,.5,.4> color rgb <.3,.3,.4>]
$ [ (cement) 1.0 color rgb <.1,.2,.2>  color rgb <.4,.4,.3>]
macro "[]"
$ }
$ }
new sc=size/dome_radius
$ scale [sc]*<1,.5,1>
$ normal { crackle 5 scale .01 }
$ finish { ambient .7 }
$ }
end

def herbage (amb,blue,scale)
new s
$ texture {
$ pigment {
$ agate
$ turbulence .8
$ octaves 3
$ color_map {
macro "()"
$ [ 0.0 color rgb < 0.4, 0.2, 0.1 > ]
$ [ 0.2 color rgb < 0.4, 0.9, (blue) > ]
$ [ 0.8 color rgb < 0.8, 0.9, 0.4 > ]
$ [ 0.9 color rgb < 0.2, 0.2, 0.2 > ]
macro "[]"
$ } // end color map
$ }  // end pigment
new sc=1/dome_radius
scale/dome_radius
$ scale [sc]*< .3, 3, .3 >
$ finish { ambient [amb] }
// $ normal { bumps 4 scale [scale] }
$ } // end texture
end

def floral (am,r,g,b,scale, cover1,cover2 )
new s
$ texture {
$ pigment {
$ agate
$ turbulence .5
$ color_map {
s=\91+" [cover1] color rgbt < [r], [g], [b], 0.1 > "+\93+\13+\10; out s
s=\91+" [cover2] color rgbt < 1.0, 1.0, 1.0,  1 > "+\93+\13+\10; out s
scale/dome_radius
$ } // end color map
$ }  // end pigment
$ scale [scale]
$ finish { ambient [am] }
$ } // end texture
end

def trees ()
tree1 ( 30,0,0,50,1,.05)
tree1 (-30,0,0,50,1,.05)
end

def frond
$ texture {
$ pigment {
$ agate
$ turbulence .7
$ color_map {
//
macro off
//
$ [ 0.1 color rgbt < 1.0, 1.0, 1.0,  1 > ]
$ [ 0.2 color rgbt < 1.0, 1.0, 1.0,  1 > ]
$ [ 0.3 color rgbt < 1.0, 1.0, 1.0,  1 > ]
$ [ 0.4 color rgbt < 1.0, 1.0, 1.0,  1 > ]
$ [ 0.5 color rgbt < 1.0, 1.0, 1.0,  1 > ]
$ [ 0.6 color rgbt < 1.0, 1.0, 1.0,  1 > ]
$ [ 0.7 color rgbt < 1.0, 1.0, 1.0,  1 > ]
$ [ 0.8 color rgbt < 1.0, 1.0, 1.0,  1 > ]
$ [ 0.90 color rgbt < 0.6, 0.9, 0.4, 0 > ]
$ [ 0.94 color rgbt < 0.6, 0.9, 0.3, 0 > ]
$ [ 0.95 color rgbt < 0.2, 0.2, 0.2, 0 > ]
macro on
//
$ } // end color map
$ }  // end pigment
$ scale < 10, 10, 10 >
//$ normal { bumps 9 scale 0.5 }
$ finish { ambient [am] }
$ } // end texture
end

def tier
//for tree
$ union {
$ cone { 0,[r],  -20*y, .1 }
$ sphere { 0, [r] }
$ scale < 1, .3, 2 >
$ rotate < 0,[a],0>
$ translate <[xo],[yo],[zo] >
do frond
$ }
end

def tree1 (x,y,z,yn,sct,am)
new xo,yo,rn
$ union {
// trunk
r=1; rn=0.4
$ cone { < 0,0,0 >,[r], <0,[yn],0 >, [rn]
$ pigment { color rgb < .6,.5, .5 > }
$ }
$
yo=yn+10; r=10; a=0
// fronds
xo=0
yo-5; a+10; zo=-2; r=07; do tier
yo-5; a-10; zo=+2; r=08; do tier
yo-5; a+10; zo=-2; r=09; do tier
yo-5; a-10; zo=+2; r=10; do tier
yo-5; a+10; zo=-2; r=11; do tier
yo-5; a-10; zo=+2; r=12; do tier
yo-5; a+10; zo=-2; r=12; do tier
yo-5; a-10; zo=+2; r=12; do tier
$ // whole tree
$ scale [sct]
$ translate < [x],[y],[z] >
$ } // end union tree
end

def generate_menus (mdl="geometrics")
input "geo.pro"
output datapath+"geo.win"
new w,v,i,s,j,k
$ main_menu=CreateMenu()
new collect off
new group_items off
loop
 i+1; if i>100; exit
 in s
 if no inf(); exit
 w=word(s,1)
 if w="def"
  w=word(s,0)
  if w=mdl; collect on
 endif
 if collect
  if w="meta"
   w=word(s,0)
   if w="end"; exit
   if w="group"
    w=word(s,0)
    if w="end"; group_items off; reloop
    w=mid(w,2,len(w)-2)
    j+1; $ menu[j]=CreateMenu()
    $ AppendMenu (main_menu, MF_POPUP, menu[j], '[w]')
    group_items on; reloop
   endif
  else
   if group_items
    if w="new"; w=word(s,0)
    if w="/"; reloop
    v=word(s,0); // check or value
    // geo.win
    k+1; $ AppendMenu (menu[j], MF_STRING, 100+k, '[w]')
    new parameter[k]=w
   endif
  endif
 endif
endl
$ SetMenu (hWnd, main_menu)
$
$ def service_menus
$ which wParam
$ loop
new en=k
new p,s
k=0
loop
 k+1
 if k>en; exit
 p=parameter[k]
 s=[p]
 // meta change values or toggle
 $  ? [k]; set [p]=[s]; exit
endl
$  exit
$ endl
$ end
output ""
end

def trin (s)
new wp=@2; @2=0
new v1=word(s,0), v2=word(s,0), v3=word(s,0), ww=word(s,0)
new x1=x[v1],y1=y[v1],z1=z[v1],x2=x[v2],y2=y[v2],z2=z[v2],x3=x[v3],y3=y[v3],z3=z[v3]
$ triangle { <[x1],[y1],[z1]>,<[x2],[y2],[z2]>,<[x3],[y3],[z3]> [ww]
end

def tri (s)
new wp=@2; @2=0
new v1=word(s,0), v2=word(s,0), v3=word(s,0), ww=word(s,0)
new x1=x[v1],y1=y[v1],z1=z[v1],x2=x[v2],y2=y[v2],z2=z[v2],x3=x[v3],y3=y[v3],z3=z[v3]
$ triangle { <[x1],[y1],[z1]>,<[x2],[y2],[z2]>,<[x3],[y3],[z3]> [ww]
// dxf codings here
// x1+1; y1+1; z1+1;x2+1;y2+1;z2+1;x3+1;y3+1;z3+1
new t='0'+cr+'3DFACE'+cr+'8'+cr+'A'+cr _
 +'10'+cr+'[x1]'+cr+'20'+cr+'[z1]'+cr+'30'+cr+'[y1]'+cr _
 +'11'+cr+'[x2]'+cr+'21'+cr+'[z2]'+cr+'31'+cr+'[y2]'+cr _
 +'12'+cr+'[x3]'+cr+'22'+cr+'[z3]'+cr+'32'+cr+'[y3]'+cr _
 +'13'+cr+'[x3]'+cr+'23'+cr+'[z3]'+cr+'33'+cr+'[y3]'+cr
seek(dxfpt); put(t);set dxfpt+len(t)
@2=wp
end

color
// +'62'+cr+'0'+cr _ 
end

// end geo.pro
